#include <stdio.h>
#include <unistd.h>

#include "libnomad/libnomad.h"

njb_t njbs[ NJB_MAX_DEVICES ];

int main()
{
	guint number;
	NomadJukebox *jukebox;
	const gchar *owner;

	g_type_init();
	g_thread_init( NULL );
	
	NJB_Set_Unicode( NJB_UC_UTF8 );

	number = 0;
	if( NJB_Discover( njbs, 0, &number ) == -1 ) {
		fprintf( stderr, "Error discovering jukeboxes\n" );
	}
	if( number == 0 ) {
		fprintf( stderr, "no NJB devices found\n" );
		return 0;
	}
	
	jukebox = nomad_jukebox_new( &njbs[ 0 ] );
	if( ! nomad_jukebox_acquire( jukebox ) ) {
		fprintf( stderr, "failed to acquire jukebox" );
		return 0;
	}

	owner = nomad_jukebox_get_ownerstring( jukebox );
	printf( "Owner: %s\n", owner );
	
	nomad_jukebox_release( jukebox );

	return 0;
}
