(* $Id: netdate.ml,v 1.1 2001/08/30 19:50:42 gerd Exp $
 * ----------------------------------------------------------------------
 *
 *)

open Unix

let wkday = [| "Sun"; "Mon"; "Tue"; "Wed"; "Thu"; "Fri"; "Sat" |];;

let weekday = [| "Sunday"; "Monday"; "Tuesday"; "Wednesday"; "Thursday";
		 "Friday"; "Saturday" |];;

let mnames = [| "Jan"; "Feb"; "Mar"; "Apr"; "May"; "Jun";
		"Jul"; "Aug"; "Sep"; "Oct"; "Nov"; "Dec" |];;

let mk_mail_date t =
  let r = gmtime t in
  Printf.sprintf "%s, %02d %s %04d %02d:%02d:%02d GMT"
    wkday.(r.tm_wday)
    r.tm_mday
    mnames.(r.tm_mon)
    (r.tm_year + 1900)
    r.tm_hour
    r.tm_min
    r.tm_sec
;;


let mk_usenet_date t =
  let r = gmtime t in
  Printf.sprintf "%s, %02d-%s-%02d %02d:%02d:%02d GMT"
    weekday.(r.tm_wday)
    r.tm_mday
    mnames.(r.tm_mon)
    (r.tm_year mod 100)
    r.tm_hour
    r.tm_min
    r.tm_sec
;;



(* ======================================================================
 * History:
 * 
 * $Log: netdate.ml,v $
 * Revision 1.1  2001/08/30 19:50:42  gerd
 * 	Initial revision.
 *
 * 
 *)
