/*
 * File: scroll.c
 * Author: Brent Hendricks
 * Project: NetSpades
 * Date: 3/30/98
 *
 * This file contains functions handling scrolling in SLang.  I took
 * most of it out of the demos distributed with SLang.
 *
 * Copyright (C) 1998 Brent Hendricks.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

    
#include <config.h>

#include <stdlib.h>
#include <slang.h>

#include <scroll.h>
#include <sl_io.h>

#ifdef DEBUG_MEM
# include <dmalloc.h>
#endif

static Line_Type *Win_Lines = NULL;
static SLscroll_Window_Type Line_Window;
static Line_Type *lastline = NULL;
static int numline=0;

/* Initialize Scroll data structures */
void ScrollInit( void ) {

  int i;
  Line_Type* line;
  
  for( i=0; i< STATHEIGHT; i++) {
    numline++;

    if (NULL == (line = create_line (" "))) {
      fprintf( stderr, "Out of memory." );
      free_lines ();
      exit(1);
    }
	
    if (lastline == NULL)
      Win_Lines = line;
    else 
      lastline->next = line;
	
    line->prev = lastline;
    line->next = NULL;
    
    lastline = line;
  }
    
  memset ((char *)&Line_Window, 0, sizeof (SLscroll_Window_Type));
    
  Line_Window.current_line = (SLscroll_Type *) Win_Lines;
  Line_Window.lines = (SLscroll_Type *) Win_Lines;
  Line_Window.line_num = 1;
  Line_Window.num_lines = numline;
    
}

/* Create new Line_Type node and initialze with string */
static Line_Type *create_line (char *buf) {

  Line_Type *line;

  line = (Line_Type *) malloc (sizeof (Line_Type));
  if (line == NULL)
    return NULL;

  memset ((char *) line, sizeof (Line_Type), 0);

  line->data = SLmake_string (buf);   /* use a slang routine */
  if (line->data == NULL) {
    free (line);
    return NULL;
  }
  
  return line;
}


/* Add Line and scroll */
void AddScrollLine( char* buf ) {

  Line_Type *line;

  line = create_line( buf );

  /* Add line to linked list */
  if (lastline == NULL)
      Win_Lines = line;
  else 
    lastline->next = line;
	
  line->prev = lastline;
  line->next = NULL;
	
  lastline = line;

  numline++;
  
  Line_Window.num_lines = numline;

  if( numline > STATHEIGHT) {
    SLscroll_next_n (&Line_Window, 1);
    Line_Window.top_window_line = Line_Window.current_line;
  }
  
  update_display();
  
}


void update_display (void) {

  unsigned int row;
  Line_Type *line;

  SLsig_block_signals ();

  Line_Window.nrows = STATHEIGHT;

  /* Always make the current line equal to the top window line. */
  if (Line_Window.top_window_line != NULL)
    Line_Window.current_line = Line_Window.top_window_line;

  SLscroll_find_top (&Line_Window);
   
  row = 0;
  line = (Line_Type *) Line_Window.top_window_line;
   
  SLsmg_normal_video ();
   
  while ( row < Line_Window.nrows) {

    SLsmg_gotorc (STATTOP+row, 0);
	
    if (line != NULL) {
      SLsmg_write_string (line->data);
      line = line->next;
    }
    SLsmg_erase_eol ();
    row++;
  }
   
  SLsmg_refresh ();
  SLsig_unblock_signals ();
}


void free_lines (void) {

  Line_Type *line, *next;
  
  line = Win_Lines;
  while (line != NULL) {
    next = line->next;
    if (line->data != NULL)
      free (line->data);
    free (line);
    line = next;
  }
  Win_Lines = NULL;
}
