#!/usr/bin/perl
#
# See LICENSE for copyright information
#
# check_named_proc.pl <host> [warn] [critical] [process] <port>
#
# Netsaint host script to check to see if a certain process is running.
#

require 5.003;
BEGIN { $ENV{PATH} = '/bin' }
use Socket;
use POSIX;
use strict;

sub usage;

my $TIMEOUT = 15;

my %ERRORS = ('UNKNOWN', '-1',
		'OK', '0',
		'WARNING', '1',
		'CRITICAL', '2');

my $remote = shift;
my $warn = shift;
my $crit = shift;
my $args = shift || &usage(%ERRORS);
my $port = shift || 1040;

my $remoteaddr = inet_aton("$remote");
my $paddr = sockaddr_in($port, $remoteaddr) || die "Can't create info for connection: #!\n";;
my $proto = getprotobyname('tcp');
socket(Server, PF_INET, SOCK_STREAM, $proto) || die "Can't create socket: $!";
setsockopt(Server, SOL_SOCKET, SO_REUSEADDR, 1);
connect(Server, $paddr) || die "Can't connect to server: $!";

my $state = "OK";
my $answer = undef;

# Just in case of problems, let's not hang NetSaint
$SIG{'ALRM'} = sub { 
     close(Server);
     select(STDOUT);
     print "No Answer from Client\n";
     exit $ERRORS{"UNKNOWN"};
};
alarm($TIMEOUT);

select(Server);
$| = 1;

print Server "named_proc $args\n";

my ($servanswer) = <Server>;
alarm(0);
close(Server);
select(STDOUT);

if ($servanswer <= $warn)
  { 
  $state = "WARNING";
  $answer = "Only $servanswer processes named $args running\n";
  }
elsif ($servanswer <= $crit)
  {
  $state = "CRITICAL";
  $answer = "Only $servanswer processes named $args running\n";
  }
elsif ($servanswer > $warn)
  {
  $answer = "$servanswer processes named $args running\n";
  }
else
  {
  $state = "UNKNOWN";
  $answer = "Number of processes named $args unknown!\n";
  }
print $answer;
exit $ERRORS{$state};

sub usage
  {
  print "Minimum arguments not supplied!\n\n";
  print "Perl Check Named Process plugin for NetSaint\n";
  print "Copyright (c) 2000 Charlie Cook & Nick Reinking\n\n";
  print "Usage: $0 <host> <warn> <crit> <process> <port>\n\n";
  print "<warn> = Number of processes named <process> to warn at.\n";
  print "<crit> = Number of processes named <process> to go critical at.\n";
  print "<process> = Name of process to look for.\n";
  print "<port> = Port that the status daemon is running on <host>.\n";
  exit $ERRORS{"UNKNOWN"};
  }
