/* Add your copyright here */

#ifndef __nd_raw_proto_h
#define __nd_raw_proto_h

#include <netdude/nd_packet.h>
#include <netdude/nd_trace.h>

/**
 * nd_raw_proto_init - initializes raw data protocol.
 *
 * The function initializes the raw protocol to make it
 * available for subsequent calls to nd_raw_proto_get().
 * This pseudo-protocol uses the ASCII/hex editor to edit
 * the packet data.
 */ 
void         nd_raw_proto_init(void);

/**
 * nd_raw_proto_get - returns raw data protocol.
 *
 * The function returns the raw protocol. The same pointer
 * is returned each time.
 *
 * Returns: protocol.
 */
ND_Protocol *nd_raw_proto_get(void);

#endif
