/*

Copyright (C) 2000, 2001, 2002 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/

#include <netdude/nd.h>
#include <netdude/nd_gettext.h>
#include <netdude/nd_debug.h>
#include <netdude/nd_gui.h>
#include <netdude/nd_packet_iterator.h>
#include <netdude/nd_dialog.h>

#include <nd_sll.h>
#include <nd_sll_callbacks.h>


void    
nd_sll_pkttype_cb(ND_Packet   *packet,
		  guchar      *header,
		  guchar      *data)
{
  static ND_ProtoCallbackData cb_data;
  struct sll_header *sllhdr;
  
  sllhdr = (struct sll_header *) header;
  nd_proto_cb_data_init(&cb_data, nd_sll_get(), data, data-header, FALSE);

  nd_dialog_number(_("Enter packet type:"),
		   ND_BASE_DEC,
		   ntohs(sllhdr->sll_pkttype),
		   65535,
		   nd_proto_iterate_16bit_cb,
		   NULL,
		   packet, &cb_data);
}


void    
nd_sll_hatype_cb(ND_Packet   *packet,
		 guchar      *header,
		 guchar      *data)
{
  static ND_ProtoCallbackData cb_data;
  struct sll_header *sllhdr;
  
  sllhdr = (struct sll_header *) header;
  nd_proto_cb_data_init(&cb_data, nd_sll_get(), data, data-header, FALSE);

  nd_dialog_number(_("Enter hardware address type:"),
		   ND_BASE_DEC,
		   ntohs(sllhdr->sll_hatype),
		   65535,
		   nd_proto_iterate_16bit_cb,
		   NULL,
		   packet, &cb_data);
}


void    
nd_sll_halen_cb(ND_Packet   *packet,
		guchar      *header,
		guchar      *data)
{
  static ND_ProtoCallbackData cb_data;
  struct sll_header *sllhdr;
  
  sllhdr = (struct sll_header *) header;
  nd_proto_cb_data_init(&cb_data, nd_sll_get(), data, data-header, FALSE);

  nd_dialog_number(_("Enter hardware address len type:"),
		   ND_BASE_DEC,
		   ntohs(sllhdr->sll_halen),
		   65535,
		   nd_proto_iterate_16bit_cb,
		   NULL,
		   packet, &cb_data);
}


static void
sll_addr_cb (guchar     *address,
	      int         address_len,
	      ND_Packet  *packet,
	      void       *user_data)
{
  ND_PacketIterator     pit;
  struct sll_header    *sllhdr;

  for (nd_pit_init(&pit, packet->trace, TRUE); nd_pit_get(&pit); nd_pit_next(&pit))
    {
      sllhdr = (struct sll_header *) nd_packet_get_data(nd_pit_get(&pit), nd_sll_get(), 0);
      if (!sllhdr)
	continue;

      memcpy(sllhdr->sll_addr, address, sizeof(guchar) * 8);
      nd_packet_modified_at_index(nd_pit_get(&pit), nd_pit_get_index(&pit));
    }
  
  return;
  TOUCH(address_len);
  TOUCH(user_data);
}


void    
nd_sll_addr_cb(ND_Packet   *packet,
	       guchar      *header,
	       guchar      *data)
{
  struct sll_header *sllhdr;
  
  sllhdr = (struct sll_header *) header;
  nd_dialog_hardware_address(_("Enter hardware address:"),
			     sllhdr->sll_addr, 8,
			     sll_addr_cb,
			     NULL,
			     packet, data);
}


void    
nd_sll_proto_cb(ND_Packet   *packet,
		guchar      *header,
		guchar      *data)
{
  static ND_ProtoCallbackData cb_data;
  struct sll_header *sllhdr;
  
  sllhdr = (struct sll_header *) header;
  nd_proto_cb_data_init(&cb_data, nd_sll_get(), data, data-header, FALSE);

  nd_dialog_number(_("Enter payload protocol type:"),
		   ND_BASE_HEX,
		   ntohs(sllhdr->sll_protocol),
		   65535,
		   nd_proto_iterate_16bit_cb,
		   NULL,
		   packet, &cb_data);
}
