/*

Copyright (C) 2000, 2001 Christian Kreibich <kreibich@aciri.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include <nd.h>
#include <nd_globals.h>
#include <nd_misc.h>
#include <nd_prefs.h>
#include <nd_recent.h>


static void
recent_change_menuitem(int item, char *label)
{
  GtkWidget  *w, *w2;
  char        s[LINESIZE];
  char       *s2;

  if (item < 0 || item >= NUM_RECENT)
    return;

  w = gtk_object_get_data(GTK_OBJECT(toplevel), "recent_separator");
  gtk_widget_show(w);

  sprintf(s, "recent_item%i", item);
  w = gtk_object_get_data(GTK_OBJECT(toplevel), s);

  s2 = strrchr(label, '/');
  if (s2)
    snprintf(s, LINESIZE, "%i. %s", item+1, s2+1);
  else
    snprintf(s, LINESIZE, "%i. %s", item+1, label);

  if ((w2 = gtk_object_get_data(GTK_OBJECT(toplevel), "tooltips")))
    gtk_tooltips_set_tip(GTK_TOOLTIPS(w2), w, label, NULL);
  
  gtk_widget_show(w);
  gtk_label_set_text(GTK_LABEL(GTK_BIN(w)->child), s);
}


void
nd_recent_init(void)
{
  GtkWidget * w;

  if ((w = gtk_object_get_data(GTK_OBJECT(toplevel), "recent_separator")))
    gtk_widget_hide(w);
  if ((w = gtk_object_get_data(GTK_OBJECT(toplevel), "recent_item0")))
    gtk_widget_hide(w);
  if ((w = gtk_object_get_data(GTK_OBJECT(toplevel), "recent_item1")))
    gtk_widget_hide(w);
  if ((w = gtk_object_get_data(GTK_OBJECT(toplevel), "recent_item2")))
    gtk_widget_hide(w);
  if ((w = gtk_object_get_data(GTK_OBJECT(toplevel), "recent_item3")))
    gtk_widget_hide(w);
  if ((w = gtk_object_get_data(GTK_OBJECT(toplevel), "recent_item4")))
    gtk_widget_hide(w);

  nd_recent_reload_entries();
}


void
nd_recent_reload_entries(void)
{
  char   s[1024];
  char   file[MAXPATHLEN];
  int    i;

  for (i = 0; i < NUM_RECENT; i++)
    {
      sprintf(s, "recent_%i", i);
      if (nd_prefs_get_item(s, file))
	recent_change_menuitem(i, file);
    }
}


void 
nd_recent_add_file(char *filename)
{
  char  s[1024];
  char  file[MAXPATHLEN];
  char  key[128];
  int   i;

  if (!filename || filename[0] == '\0')
    return;
  
  for (i = 0; i < NUM_RECENT; i++)
    {
      snprintf(key, 128, "recent_%i", i);
      
      if (nd_prefs_get_item(key, file))
	{
	  if (!strcmp(filename, file))
	    return;
	}
    }
  
  for (i = NUM_RECENT - 2; i >= 0; i--)
    {
      sprintf(s, "recent_%i", i);
      
      if (nd_prefs_get_item(s, file))
	{
	  recent_change_menuitem(i+1, file);
	  sprintf(s, "recent_%i", i+1);
	  nd_prefs_set_item(s, file);
	}
    }
  
  nd_prefs_set_item("recent_0", filename);
  recent_change_menuitem(0, filename);
}


void 
nd_recent_load(int index)
{
  char      s[1024];
  char      file[MAXPATHLEN];

  if (index < 0 || index >= NUM_RECENT)
    return;

  sprintf(s, "recent_%i", index);

  if (nd_prefs_get_item(s, file))
    {
      if (trace.dirty)
	{
	}
      else
	{
	  nd_trace_load(file);
	}
    }
}
