/*

Copyright (C) 2000, 2001 Christian Kreibich <kreibich@aciri.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/param.h>
#ifdef LINUX
#define __FAVOR_BSD
#endif
#include <gtk/gtk.h>

#include <nd_macros.h>
#include <nd_globals.h>
#include <nd_misc.h>
#include <nd_prefs.h>
#include <interface.h>
#include <support.h>


static GtkWidget *filesel_dialog = NULL;

void     
nd_filesel_select_tcpdump(void)
{
  char tcpdump_path[MAXPATHLEN];

  if (!filesel_dialog)
    filesel_dialog = create_filesel();

  gtk_window_set_title(GTK_WINDOW(filesel_dialog), _("Select Tcpdump Executable"));

  gtk_object_set_data(GTK_OBJECT(filesel_dialog), "tcpdump_path", (void *)1);

  if (nd_prefs_get_item("tcpdump_path", tcpdump_path))
    gtk_file_selection_set_filename(GTK_FILE_SELECTION(filesel_dialog),
				    tcpdump_path);

  gtk_widget_show(filesel_dialog);
}


void
nd_filesel_trace_load(void)
{
  char load_dir[MAXPATHLEN];

  if (!filesel_dialog)
    filesel_dialog = create_filesel();

  gtk_window_set_title(GTK_WINDOW(filesel_dialog), _("Load Tcpdump Tracefile"));

  gtk_object_set_data(GTK_OBJECT(filesel_dialog), "load_trace", (void *)1);

  if (nd_prefs_get_item("load_dir", load_dir))
    gtk_file_selection_set_filename(GTK_FILE_SELECTION(filesel_dialog),
				    load_dir);

  gtk_widget_show(filesel_dialog);
}


void
nd_filesel_trace_save_as(void)
{
  char  save_dir[MAXPATHLEN];
  
  if (!filesel_dialog)
    filesel_dialog = create_filesel();

  gtk_window_set_title(GTK_WINDOW(filesel_dialog), _("Save Tcpdump Tracefile"));

  gtk_object_set_data(GTK_OBJECT(filesel_dialog), "save_trace", (void *)1);

  if (nd_prefs_get_item("save_dir", save_dir))
    {
      char s[MAXPATHLEN];
      char *trace_filename_only;

      if ((trace_filename_only = strrchr(trace.filename, '/')) != NULL)
	trace_filename_only++;

      snprintf(s, MAXPATHLEN, "%s/%s", save_dir, trace_filename_only);
      gtk_file_selection_set_filename(GTK_FILE_SELECTION(filesel_dialog),
				      s);
    }
  else
    {
      gtk_file_selection_set_filename(GTK_FILE_SELECTION(filesel_dialog),
				      trace.filename);
    }

  gtk_widget_show(filesel_dialog);
}


void
nd_filesel_ok(void)
{
  char      *s;
  char      *lastslash;
  char       savefile_dir[MAXPATHLEN]; 

  if (!filesel_dialog)
    return;

  s = strdup(gtk_file_selection_get_filename(GTK_FILE_SELECTION(filesel_dialog)));
  
  if (gtk_object_get_data(GTK_OBJECT(filesel_dialog), "load_trace"))
    {
      if (nd_misc_is_tcpdump_file(s))
	{
	  gtk_object_remove_data(GTK_OBJECT(filesel_dialog), "load_trace");
	  gtk_widget_hide(filesel_dialog);

	  snprintf(savefile_dir, MAXPATHLEN, "%s", s);
	  if ((lastslash = strrchr(savefile_dir, '/')) != NULL)
	    *(lastslash+1) = '\0';    
	  
	  nd_prefs_set_item("load_dir", savefile_dir);
	  nd_trace_load(s);
	}
    }
  else if (gtk_object_get_data(GTK_OBJECT(filesel_dialog), "save_trace"))
    {
      gtk_object_remove_data(GTK_OBJECT(filesel_dialog), "save_trace");
      gtk_widget_hide(filesel_dialog);

      snprintf(savefile_dir, MAXPATHLEN, "%s", s);
      if ((lastslash = strrchr(savefile_dir, '/')) != NULL)
	*(lastslash+1) = '\0';    

      nd_prefs_set_item("save_dir", savefile_dir);
      nd_trace_save_as(s);
    }
  else if (gtk_object_get_data(GTK_OBJECT(filesel_dialog), "tcpdump_path"))
    {
      if (nd_misc_can_exec(s))
	{
	  gtk_object_remove_data(GTK_OBJECT(filesel_dialog), "tcpdump_path");
	  gtk_widget_hide(filesel_dialog);
	  
	  nd_prefs_set_item("tcpdump_path", s);	      
	}
    }

  FREE(s);
}


void
nd_filesel_cancel(void)
{
  if (!filesel_dialog)
    return;

  gtk_widget_hide(filesel_dialog);
}

