/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zvtm.lens;

import net.claribole.zvtm.lens.TLens;

public class TInverseCosineLens
extends TLens {
    protected float aT = 0.0f;
    protected float bT = 0.0f;
    protected float cT = 0.0f;

    public TInverseCosineLens() {
        this.MM = 2.0f;
        this.updateMagBufferWorkingDimensions();
        this.computeDropoffFactors();
    }

    public TInverseCosineLens(float mm) {
        this.MM = mm;
        this.updateMagBufferWorkingDimensions();
        this.computeDropoffFactors();
    }

    public TInverseCosineLens(float mm, float tc, float tf, int outerRadius, int innerRadius) {
        this.MM = mm;
        this.LR1 = outerRadius;
        this.LR2 = innerRadius;
        this.MMTc = tc;
        this.MMTf = tf;
        this.updateMagBufferWorkingDimensions();
        this.computeDropoffFactors();
    }

    public TInverseCosineLens(float mm, float tc, float tf, int outerRadius, int innerRadius, int x, int y) {
        this.MM = mm;
        this.LR1 = outerRadius;
        this.LR2 = innerRadius;
        this.MMTc = tc;
        this.MMTf = tf;
        this.updateMagBufferWorkingDimensions();
        this.computeDropoffFactors();
        this.lx = x;
        this.ly = y;
    }

    public void setOuterRadius(int r) {
        super.setOuterRadius(r);
        this.computeDropoffFactors();
    }

    public void setInnerRadius(int r) {
        super.setInnerRadius(r);
        this.computeDropoffFactors();
    }

    public void setRadii(int outerRadius, int innerRadius) {
        this.setRadii(outerRadius, innerRadius, true);
    }

    public void setRadii(int outerRadius, int innerRadius, boolean forceRaster) {
        super.setRadii(outerRadius, innerRadius, forceRaster);
        this.computeDropoffFactors();
    }

    public void setMMandRadii(float mm, int outerRadius, int innerRadius) {
        this.setMMandRadii(mm, outerRadius, innerRadius, true);
    }

    public void setMMandRadii(float mm, int outerRadius, int innerRadius, boolean forceRaster) {
        super.setMMandRadii(mm, outerRadius, innerRadius, forceRaster);
        this.computeDropoffFactors();
    }

    public void setMaximumMagnification(float mm) {
        this.setMaximumMagnification(mm, true);
    }

    public void setMaximumMagnification(float mm, boolean forceRaster) {
        super.setMaximumMagnification(mm, forceRaster);
        this.computeDropoffFactors();
    }

    void computeDropoffFactors() {
        this.aT = 1.0f / (float)(this.LR1 - this.LR2);
        this.bT = (float)this.LR2 / (float)(this.LR2 - this.LR1);
        this.cT = 0.63661975f * (this.MMTf - this.MMTc);
    }

    public void gfT(float x, float y, float[] g) {
        this.d = Math.sqrt(Math.pow(x - (float)this.sw - (float)this.lx, 2.0) + Math.pow(y - (float)this.sh - (float)this.ly, 2.0));
        g[0] = this.d <= (double)this.LR2 ? this.MMTf : (this.d <= (double)this.LR1 ? this.MMTf - this.cT * (float)Math.acos(Math.pow(this.d * (double)this.aT + (double)this.bT - 1.0, 2.0)) : 0.0f);
    }
}

