/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zgrviewer;

import net.claribole.zgrviewer.Ring;

class RingManager {
    Ring[] rings = new Ring[0];

    RingManager() {
    }

    Ring getRing(double direction, double size, double ringStep) {
        double a;
        if (direction < 0.0) {
            direction = Math.PI * 2 + direction;
        }
        for (int i = 0; i < this.rings.length; ++i) {
            a = Math.abs(Math.atan2(size, (double)this.rings[i].rank * ringStep));
            if (this.rings[i].intersectsConeOfInfluence(direction - a, direction + a)) continue;
            this.rings[i].addNode(direction - a, direction + a);
            return this.rings[i];
        }
        Ring r = this.createNewRing();
        a = Math.abs(Math.atan2(size, ringStep));
        r.addNode(direction - a, direction + a);
        return r;
    }

    private Ring createNewRing() {
        Ring[] tr = new Ring[this.rings.length + 1];
        System.arraycopy(this.rings, 0, tr, 0, this.rings.length);
        tr[this.rings.length] = new Ring(tr.length);
        this.rings = tr;
        return this.rings[this.rings.length - 1];
    }
}

