/*
 * Copyright (c) 1997 Adrian Sun (asun@zoology.washington.edu)
 * All rights reserved. See COPYRIGHT.
 */

#include <stdio.h>
#include <sys/types.h>
#include <string.h>
#include <signal.h>

#include <atalk/dsi.h>
#include <netatalk/endian.h>

/* server generated tickles. as this is only called by the tickle handler,
 * we don't need to block signals. well, actually, we might get it during
 * a SIGHUP. */
void dsi_tickle(DSI *dsi)
{
  char block[DSI_BLOCKSIZ];
  sigset_t oldset;
  u_int16_t id;

  id = htons(dsi_serverID(dsi));

  memset(block, 0, sizeof(block));
  block[0] = DSIFL_REQUEST;
  block[1] = DSIFUNC_TICKLE;
  memcpy(block + 2, &id, sizeof(id));
  /* code = len = reserved = 0 */

  sigprocmask(SIG_BLOCK, &dsi->sigblockset, &oldset);
  dsi_stream_write(dsi, block, DSI_BLOCKSIZ);
  sigprocmask(SIG_SETMASK, &oldset, NULL);
}

