#
# This script was written by Pasi Eronen <pasi.eronen@nixu.com>
#
# See the Nessus Scripts License for details
#
# Changes by Tenable:
#  - Description
#  - Extract and display the load and the hostname
#

 desc["english"] = "
Synopsis :


XDMCP is running on the remote host.

Description :

XDMCP allow a Unix user to remotely obtain a graphical X11 login 
(and therefore act as a local user on the remote host).

If an attacker gains a valid login and password, he may
be able to use this service to gain further access
on the remote host. An attacker may also use this service
to mount a dictionary attack against the remote host to try
to log in remotely.

Note that XDMCP (the Remote Desktop Protocol) is vulnerable
to Man-in-the-middle attacks, making it easy for attackers to
steal the credentials of legitimates users by impersonating the
XDMCP server. In addition to this, XDMCP is not a ciphered protocol
which make it easy for an attacker to capture the keystrokes 
entered by the user.

Solution :

Disable the XDMCP if you do not use it, and do not allow this 
service to run across the internet

Risk factor :

Low / CVSS Base Score : 1.9
(AV:R/AC:H/Au:NR/C:P/I:N/A:N/B:N)";

if(description)
{
 script_id(10891);
#script_cve_id("CVE-MAP-NOMATCH");
 script_version("$Revision: 1.7 $");
 name["english"] = "X Display Manager Control Protocol (XDMCP)";
 script_name(english:name["english"]);
 

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks if XDM has XDMCP protocol enabled";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2002 Pasi Eronen");
 family["english"] = "Useless services";
 script_family(english:family["english"]);
 exit(0);
}

#
# The script code starts here
#
function report(hostname, status)
{
  local_var report;

  if ( hostname ) report += ' Hostname : ' + hostname + '\n';
  if ( status   ) report += ' Status   : ' + status + '\n';
 
  if ( report ) report = '\n\nPlugin output :\n\nUsing XDMCP, it was possible to obtain the following information\nabout the remote host :\n\n' + report;
  security_warning(port:177, protocol:"udp", data:desc["english"] + report);
  exit(0);
}

# this magic info request packet
req = raw_string(0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00);

if(!get_udp_port_state(177))exit(0);

soc = open_sock_udp(177);

if(soc)
{
        send(socket:soc, data:req);
        result  = recv(socket:soc, length:1000);
        if (result &&
	    strlen(result) > 3 &&
	    ord(result[0]) == 0 &&
	    ord(result[1]) == 1 &&
	    ord(result[2]) == 0 &&
	    ord(result[3]) == 5 )
		{
	 	offset = 6;
		if ( strlen(result) <= offset ) report();
	 	len = ord(result[offset]) * 256 + ord(result[offset+1]); offset += 2;
		offset += len;
		if ( strlen(result) <= offset ) report();
		len = ord(result[offset]) * 256 + ord(result[offset+1]); offset += 2;
		if ( strlen(result) <= offset + len ) report();
		hostname = substr(result, offset, offset + len - 1);
		offset += len;
		if ( strlen(result) <= offset ) report(hostname:hostname);
		len = ord(result[offset]) * 256 + ord(result[offset+1]); offset += 2;
		if ( strlen(result) < offset + len ) report(hostname:hostname);
		status = substr(result, offset, offset + len - 1);
		report(hostname:hostname, status:status);
		}
        
}
