/********************************************************************************
 *                              Nepenthes
 *                        - finest collection -
 *
 *
 *
 * Copyright (C) 2005  Paul Baecher & Markus Koetter
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 * 
 * 
 *             contact nepenthesdev@users.sourceforge.net  
 *
 *******************************************************************************/

 /* $Id: WINSDialogue.hpp 330 2006-02-20 09:20:44Z common $ */


#ifndef HAVE_WINSDIALOGUE_HPP
#define HAVE_WINSDIALOGUE_HPP

#include "Dialogue.hpp"

using namespace std;

namespace nepenthes
{
	typedef enum 
	{
		WINS_NULL,
		WINS_DONE
	} wins_state;

	class Buffer;

	class WINSDialogue : public Dialogue
	{
	public:
		WINSDialogue(Socket *socket);
		~WINSDialogue();
		ConsumeLevel incomingData(Message *msg);
		ConsumeLevel outgoingData(Message *msg);
		ConsumeLevel handleTimeout(Message *msg);
		ConsumeLevel connectionLost(Message *msg);
		ConsumeLevel connectionShutdown(Message *msg);

		void dump();

	protected:
		Buffer		*m_Buffer;
		wins_state	m_State;

	};
}

#endif
