#pragma indent
using System.Collections.Generic
using System

variant Node['a] : IEnumerable['a] \
where 'a : IComparable['a] 
  | Elem { l : Node['a]; e : 'a; r : Node['a]; }
  | Nil

  public GetEnumerator () : IEnumerator['a]
    match (this) 
      | Elem (l, e, r) =>
        foreach (x in l) yield x;
        yield e;
        foreach (x in r) yield x;
      | Nil => {}

  public Add (e : 'a) : Node['a]
    match (this)
      | Elem (l, e', r) =>
        def c = e.CompareTo (e');
        if (c < 0) Elem (l.Add (e), e', r)
        else if (c > 0) Elem (l, e', r.Add (e))
        else Elem (l, e', r)
      | Nil => Elem (Nil (), e, Nil ())

  public static FromList (e : list ['a]) : Node['a]
    e.FoldLeft (Node.Nil (), fun (e,a) { a.Add (e) })

def n = Node.FromList ([82, 2, 33, 1, 22])
def n2 = Node.FromList (["ene", "due", "rabe", "chinczyk", "zlapal", "zabe"])

foreach (e in n)
  System.Console.WriteLine (e)
  
foreach (e in n2)
  System.Console.WriteLine (e)

/*
BEGIN-OUTPUT
1
2
22
33
82
chinczyk
due
ene
rabe
zabe
zlapal
END-OUTPUT
*/
