def test (_) {
  | [x] with y = 7
  | [x, y] =>
    System.Console.WriteLine ($ "ok $x $y");
  | _ =>
    System.Console.WriteLine ("bad");
}

def test2 (_) {
  | [x, y] 
  | [x] with y = 7 
  | [] with (y = 42, x = 42) =>
    System.Console.WriteLine ($ "ok $x $y");
  | _ =>
    System.Console.WriteLine ("bad");
}

test ([3]);
test ([4]);
test ([4, 17]);

test2 ([3]);
test2 ([4]);
test2 ([4, 17]);
test2 ([]);

def f (x) {
  System.Console.WriteLine ($ "f ($x) called");
  x * 2
}

def g (l) {
  System.Console.WriteLine ($ "g ($l) called");
  match (l) {
    | [x, y]
    | [x] with y = f (x)
    | [] with ( x = 77, y = f (x) ) =>
      System.Console.WriteLine ($ "x = $x, y = $y");
    | _ =>
      System.Console.WriteLine ("oops");
  }
}

def h (l) {
  System.Console.WriteLine ($ "h ($l) called");
  match (l) {
    | [x, y]
    | [x] when f (x / 2) == 42 with y = f (x)
    | [] with ( x = 77, y = f (x) ) =>
      System.Console.WriteLine ($ "x = $x, y = $y");
    | _ =>
      System.Console.WriteLine ("the other");
  }
}

g ([2, 3]);
g ([21]);
g ([]);

h ([42]);
h ([44]);


def with_matching_1 (_ : option [list [int]]) 
  {
    | None with x = [] 
    | Some (x) =>
      System.Console.WriteLine (x)
  }
  
def with_matching_2 (_ : option [list [int]])
  {
    | Some (x)
    | None with x = []  =>
      System.Console.WriteLine (x)
  }

with_matching_1 (None ());
with_matching_2 (None ());
with_matching_1 (Some ([1]));
with_matching_2 (Some ([2]));

match ([] : list [int]) {
  | [assign] with assigns = [assign]
  | assigns =>
    System.Console.WriteLine (assigns)
}


/*
BEGIN-OUTPUT
ok 3 7
ok 4 7
ok 4 17
ok 3 7
ok 4 7
ok 4 17
ok 42 42
g ([2, 3]) called
x = 2, y = 3
g ([21]) called
f (21) called
x = 21, y = 42
g ([]) called
f (77) called
x = 77, y = 154
h ([42]) called
f (21) called
f (42) called
x = 42, y = 84
h ([44]) called
f (22) called
the other
[]
[]
[1]
[2]
[]
END-OUTPUT
*/
