class C [T] {
  public static @: (_ : T) : C[T] {
    C()
  }

  public override ToString () : string
  {
    $ "C<$(typeof(T))>"
  }
}

class B {}

class C2 {
  public static @: [X] (_ : X) : C2 {
    C2()
  }

  public override ToString () : string
  {
    "C2"
  }
}


interface IFoo {}

struct Bar1['a] where 'a : IFoo
{
    static public @:['b](_ : 'b) : Bar1['a] where 'b : IFoo
    {
        Bar1()
    }

    public override ToString () : string
    {
      "Bar1"
    }
}

struct Bar2 : IFoo {}


class Implicit
{
  public static Main() : void
  {
     def x = B() : C[B];
     def y = B() : C2;
     Nemerle.IO.print("$x $y\n");
     def bar : Bar1.[IFoo] = Bar2();
     Nemerle.IO.print("$bar\n");
  }
}

/*
BEGIN-OUTPUT
C<B> C2
Bar1
END-OUTPUT
*/
