/*
 * NcdT -- directory tree printer with extended capabilities
 * (C) 1999 by Pawel Wiecek <coven@vmh.net>
 * See Copying file for licence.
 * 
 * Utility functions
 */

#include <stdio.h>
#include <string.h>
#include "ncdt.h"

int endswith(char *s, char *e) {
 return !strcmp(s+strlen(s)-strlen(e),e);
}

char *nicenum(unsigned long n) {
 static char buf[1024];
 char tmp[5];
 
 if(n>999) {
  nicenum(n/1000);
  sprintf(tmp,",%03ld",n%1000);
  strcat(buf,tmp);
 } else {
  sprintf(buf,"%ld",n);
 }
 return buf;
}

char *nicetime(unsigned long n) {
 static char buf[1024];
 
 if(n>3600) sprintf(buf,"%d:%02d:%02d",(int)(n/3600),(int)((n/60)%60),
		    (int)(n%60));
       else sprintf(buf,"%d:%02d",(int)(n/60),(int)(n%60));
 return buf;
}
