# NanoBlogger Weblog Status Plugin
# generate some misc. statistics about the weblog
#
# sample code for templates - based on default stylesheet
#
# <div class="sidetitle">
# Weblog Status
# </div>
# <div class="side">
# $NB_Blog_Status
# </div>

OUTPUT_FILE="$BLOG_DIR/$PARTS_DIR/blog_status.$NB_FILETYPE"
TEMPLATE_FILE="$BLOG_DIR/$TEMPLATE_DIR/blog_status.htm"

nb_msg "generating weblog status ..."
if [ ! -f "$TEMPLATE_FILE" ] ; then
	# TEMPLATE_FILE doesn't exist, get it from default
	cp "${BASE_DIR}/default/${TEMPLATE_DIR}/blog_status.htm" "$TEMPLATE_FILE" || die "$nb_plugin: cannot copy ${BASE_DIR}/${ARCHIVES_DIR}/${TEMPLATE_DIR}! repair nanoblogger! goodbye."
fi

[ -r "$TEMPLATE_FILE" ] || \
    die "`basename $0`: $TEMPLATE_FILE doens't exist! goodbye."

query_db all
TOTAL_CATEGORIES=`echo "$db_categories" |grep -c "."`
TOTAL_ENTRIES=`echo "$DB_RESULTS" | grep -c "."`
LAST_ENTRY=`echo "$DB_RESULTS" |sed 1q`
read_metadata DATE "$NB_DATA_DIR/$LAST_ENTRY"; NB_EntryDate="$NB_Metadata"
LAST_ENTRY_TIME="$NB_EntryDate"
LAST_UPDATED=`filter_dateformat "$DATE_FORMAT"`

NB_Blog_Status=$(< "$TEMPLATE_FILE")

cat > "$OUTPUT_FILE" <<-EOF
	cat <<-TMPL

		$NB_Blog_Status

	TMPL
EOF

NB_Blog_Status=$(. "$OUTPUT_FILE")

cat > "$OUTPUT_FILE" <<-EOF
	$NB_Blog_Status
EOF
