<?php
# $Id: hosts.php,v 1.13 2002/06/22 06:15:19 kemuri Exp $

/*
 * Copyright (c) 2002 Ypsilon.Net AG, Germany
 *
 * This file is part of Nagat.
 * 
 * Nagat is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * Nagat is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Nagat; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

# Page variables
define("PAGE_ID","hosts");
define("PAGE_TITLE","Hosts");
define("OBJECTTYPE","host");

require_once("local.inc");
include_once(NGT_LIB."head.inc");

$alter = '';
$rows = array();
$errmsg = '';
$message = '';
$objects = PluginGetObjects(OBJECTTYPE);

if( is_array($objects) ) {
	uasort($objects,"NagiosUasortObjectName");
	foreach($objects as $key => $object) {

		$alter = ($alter != "alter1") ? "alter1" : "alter2";
		$inheritance = '';

		$name = isset($object[OBJECTTYPE.'_name']) 
			? $object[OBJECTTYPE.'_name'] : $object['name'];
		$alias = isset($object['alias']) ? $object['alias'] : '';
		$address = isset($object['address']) ? $object['address'] : '';

		# Is this a inheritable object?
		if( !empty($object['name']) ) {
			$cntinh = NagiosCountInherited(OBJECTTYPE,$name);
			$inheritance = 'used by '.$cntinh.' objects';
		} else if( !empty($object['use']) ) {
			$inheritance = 'uses '.$object['use'];
		} else {
			$inheritance = '';
		}
		
		if( isset($object['register']) && $object['register'] == 0) {
			$registered = 'no';
		} else {
			$registered = 'yes';
		}


		$rows[] = <<<HTML
<tr class="$alter">
  <td><a href="hostedit.php?objectid={$key}">Edit</a></td>
  <td>{$name}</td>
  <td>{$alias}</td>
  <td>{$address}</td>
  <td>{$inheritance}</td>
  <td align="center">$registered</td>
</tr>
HTML;

	} # foreach
} else {
	$message = "No '".OBJECTTYPE."'-objects found.";
}

?>
<table border="0" cellpadding="5" cellspacing="0">
<tr>
  <td colspan="6" align="left">
  <b><?=ErrorMsg($errmsg)?>
  <?=$message?>&nbsp;</b>
  </td>
</tr>
<tr>
  <td colspan="6">
  <form action="hostedit.php">
  <input type="hidden" name="objectid" value="">
  <input type="submit" value="New">
  </form>
  </td>
</tr>
<tr class="rowsep">
  <td>&nbsp;</td>
  <td>Name</td>
  <td>Alias</td>
  <td>IP or FQDN</td>
  <td>Inheritance</td>
  <td>Registered</td>
</tr>
<?=implode("\n",$rows)?>
</table>

<?
# Beautification
if( !is_array($objects) ) {
	print "<br><br><br><br><br><br><br><br>";
}
include_once(NGT_LIB."tail.inc");
?>
