/* Copyright (C) 1979-1999 TcX AB & Monty Program KB & Detron HB	     */
/*									     */
/* This software is distributed with NO WARRANTY OF ANY KIND.  No author or  */
/* distributor accepts any responsibility for the consequences of using it,  */
/* or for whether it serves any particular purpose or works at all, unless   */
/* he or she says so in writing.  Refer to the Free Public License (the	     */
/* "License") for full details.						     *//* Every copy of this file must include a copy of the License, normally in a */
/* plain ASCII text file named PUBLIC.	The License grants you the right to  */
/* copy, modify and redistribute this file, but only under certain	     */
/* conditions described in the License.  Among other things, the License     */
/* requires that the copyright notice and this notice be preserved on all    */
/* copies.								     */

/* Optimized longlong2str function for Intel 80x86  (gcc/gas syntax) */
/* Some set sequences are optimized for pentuimpro II */

	.file	"longlong2str.s"
	.version "1.01"

.text
	.align 4

.globl	longlong2str
	.type	 longlong2str,@function

longlong2str:
	subl $80,%esp
	pushl %ebp
	pushl %esi
	pushl %edi
	pushl %ebx
	movl 100(%esp),%esi	/* Lower part of val */
	movl 104(%esp),%ebp	/* Higher part of val */
	movl 108(%esp),%edi	/* get dst */
	movl 112(%esp),%ebx	/* Radix */
	movl %ebx,%eax
	testl %eax,%eax
	jge .L144

	addl $36,%eax
	cmpl $34,%eax
	ja .Lerror		/* Wrong radix */
	testl %ebp,%ebp
	jge .L146
	movb $45,(%edi)		/* Add sign */
	incl %edi		/* Change sign of val */
	negl %esi
	adcl $0,%ebp
	negl %ebp
.L146:
	negl %ebx		/* Change radix to positive */
	jmp .L148
	.p2align 4,,7
.L144:
	addl $-2,%eax
	cmpl $34,%eax
	ja .Lerror		/* Radix in range */

.L148:
	movl %esi,%eax		/* Test if zero (for easy loop) */
	orl %ebp,%eax
	jne .L150
	movb $48,(%edi)
	incl %edi
	jmp .L164
	.p2align 4,,7

.L150:
	leal 92(%esp),%ecx	/* End of buffer */
	jmp  .L155
	.p2align 4,,7

.L153:
	/* val is stored in in ebp:esi */

	movl %ebp,%eax		/* High part of value */
	xorl %edx,%edx
	divl %ebx
	movl %eax,%ebp
	movl %esi,%eax
	divl %ebx
	movl %eax,%esi		/* quotent in ebp:esi */
	movb _dig_vec(%edx),%al   /* al is faster than dl */
	decl %ecx
	movb %al,(%ecx)		/* store value in buff */
	.p2align 4,,7
.L155:
	testl %ebp,%ebp
	ja .L153
	testl %esi,%esi		/* rest value */
	jl .L153
	je .L160		/* Ready */
	movl %esi,%eax
	movl $_dig_vec,%ebp
	.p2align 4,,7

.L154:				/* Do rest with integer precision */
	cltd
	divl %ebx
	decl %ecx
	movb (%edx,%ebp),%dl	/* bh is always zero as ebx=radix < 36 */
	testl %eax,%eax
	movb %dl,(%ecx)
	jne .L154

.L160:
	movl %ecx,%esi
	leal 92(%esp),%ecx	/* End of buffer */
	subl %esi,%ecx
	rep
	movsb

.L164:
	movl %edi,%eax		/* Pointer to end null */
	movb $0,(%edi)		/* Store the end null */

.L165:
	popl %ebx
	popl %edi
	popl %esi
	popl %ebp
	addl $80,%esp
	ret

.Lerror:
	xorl %eax,%eax		/* Wrong radix */
	jmp .L165

.Lfe3:
	.size	 longlong2str,.Lfe3-longlong2str
