unit MySQLCommonFuncs;

interface

uses
  gnugettext, SysUtils, AuxFuncs, Windows, Forms;

function GetMySQLCommandLineClientPath: WideString;
function GetMySQLAdministratorCmd: WideString;
function GetMySQLQueryBrowserCmd: WideString;

procedure RegisterMySQLApplication(Name: WideString;
  Version: WideString; InstallPath: WideString);
function ScanRegistryForProductVersion(RegMainPath: WideString;
  Key: WideString; KeyType: Integer): WideString;

implementation

// -----------------------------------------------------------------------------

function GetMySQLCommandLineClientPath: WideString;

var
  InstallDir: WideString;

begin
  if(FileExists(GetProgramFilesDir+'MySQL\bin\mysql.exe'))then
    Result:=GetProgramFilesDir+'MySQL\bin\mysql.exe'
  else if(FileExists('c:\mysql\bin\mysql.exe'))then
    Result:='c:\mysql\bin\mysql.exe'
  else
  begin
    InstallDir:=ReadFromReg(HKEY_LOCAL_MACHINE,
      '\SOFTWARE\MySQL AB\MySQL Server 4.1', 'Location', 0, '', False);

    if(FileExists(IncludeTrailingPathDelimiter(InstallDir)+
      'bin\mysql.exe'))then
      Result:=IncludeTrailingPathDelimiter(InstallDir)+'bin\mysql.exe'
    else
    begin
      InstallDir:=ReadFromReg(HKEY_LOCAL_MACHINE,
        '\SOFTWARE\MySQL AB\MySQL Server 5.0', 'Location', 0, '', False);
      if (InstallDir='') then
        InstallDir := ScanRegistryForProductVersion('\SOFTWARE\MySQL AB\MySQL Server', 'Location', 0);


      if(FileExists(IncludeTrailingPathDelimiter(InstallDir)+
        'bin\mysql.exe'))then
        Result:=IncludeTrailingPathDelimiter(InstallDir)+'bin\mysql.exe'
      else
        Result:='';
    end;
  end
end;

// -----------------------------------------------------------------------------

function GetMySQLAdministratorCmd: WideString;

var
  InstallDir: WideString;

begin
  if(FileExists(ExtractFilePath(Application.ExeName)+'MySQLAdministrator.exe'))then
    Result:=ExtractFilePath(Application.ExeName)+'MySQLAdministrator.exe'
  else
  begin
    InstallDir:=ReadFromReg(HKEY_LOCAL_MACHINE,
      '\SOFTWARE\MySQL AB\MySQL Administrator', 'Location', 0, '', False);

    if(FileExists(IncludeTrailingPathDelimiter(InstallDir)+'MySQLAdministrator.exe'))then
      Result:=IncludeTrailingPathDelimiter(InstallDir)+'MySQLAdministrator.exe'
    else
      Result:='';

    if(Result='')then
    begin
      InstallDir:=ReadFromReg(HKEY_LOCAL_MACHINE,
        '\SOFTWARE\MySQL AB\MySQL Administrator 1.0', 'Location', 0, '', False);
      if (InstallDir='') then
        InstallDir := ScanRegistryForProductVersion('\SOFTWARE\MySQL AB\MySQL Administrator', 'Location', 0);

      if(FileExists(IncludeTrailingPathDelimiter(InstallDir)+'MySQLAdministrator.exe'))then
        Result:=IncludeTrailingPathDelimiter(InstallDir)+'MySQLAdministrator.exe'
      else
        Result:='';
    end;
  end;
end;

// -----------------------------------------------------------------------------

function GetMySQLQueryBrowserCmd: WideString;

var
  InstallDir: WideString;

begin
  if(FileExists(ExtractFilePath(Application.ExeName)+'MySQLQueryBrowser.exe'))then
    Result:=ExtractFilePath(Application.ExeName)+'MySQLQueryBrowser.exe'
  else
  begin
    InstallDir := ReadFromReg(HKEY_LOCAL_MACHINE,
      '\SOFTWARE\MySQL AB\MySQL Query Browser', 'Location', 0, '', False);

    if(FileExists(IncludeTrailingPathDelimiter(InstallDir)+'MySQLQueryBrowser.exe'))then
      Result:=IncludeTrailingPathDelimiter(InstallDir)+'MySQLQueryBrowser.exe'
    else
      Result:='';

    if(Result='')then
    begin
      InstallDir := ReadFromReg(HKEY_LOCAL_MACHINE,
        '\SOFTWARE\MySQL AB\MySQL Query Browser 1.0', 'Location', 0, '', False);
      if (InstallDir='') then
        InstallDir := ReadFromReg(HKEY_LOCAL_MACHINE,
          '\SOFTWARE\MySQL AB\MySQL Query Browser 1.1', 'Location', 0, '', False);
      if (InstallDir='') then
        InstallDir := ScanRegistryForProductVersion('\SOFTWARE\MySQL AB\MySQL Query Browser', 'Location', 0);


      if(FileExists(IncludeTrailingPathDelimiter(InstallDir)+'MySQLQueryBrowser.exe'))then
        Result:=IncludeTrailingPathDelimiter(InstallDir)+'MySQLQueryBrowser.exe'
      else
        Result:='';
    end;
  end;
end;

// -----------------------------------------------------------------------------

function ScanRegistryForProductVersion(RegMainPath: WideString;
  Key: WideString; KeyType: Integer): WideString;

var
  i, j: Integer;

begin
  //Scan for
  //RegMainPath %d.%d
  //starting with 10.25 down to 1.0
  Result := '';

  for i:=10 downto 1 do
  begin
    for j:=30 downto 0 do
    begin
      Result := ReadFromReg(HKEY_LOCAL_MACHINE,
        Format(RegMainPath+' %d.%d', [i, j]),
        Key, KeyType, '', False);
      if (Result<>'') then
        break;
    end;
  end;
end;

// -----------------------------------------------------------------------------

procedure RegisterMySQLApplication(Name: WideString;
  Version: WideString; InstallPath: WideString);
var RegVersion: WideString;
  KeyName: WideString;
  MainVersion: WideString;
  p, p2: integer;
begin
  MainVersion:='';

  p:=Pos('.', Version);
  if(p>0)then
  begin
    p2:=Pos('.', Copy(Version, p+1, Length(Version)));

    if(p2>0)then
      MainVersion:=Copy(Version, 1, p2+1);
  end;

  if(MainVersion<>'')then
    KeyName:=Name+' '+MainVersion
  else
    KeyName:=Name;

  RegVersion:=ReadFromReg(HKEY_LOCAL_MACHINE,
    '\SOFTWARE\MySQL AB\'+KeyName, 'Version', 0, '');

  if(RegVersion<>Version)then
  begin
    WriteToReg(HKEY_LOCAL_MACHINE, '\SOFTWARE\MySQL AB\'+KeyName,
      'Version', 0, Version);
    WriteToReg(HKEY_LOCAL_MACHINE, '\SOFTWARE\MySQL AB\'+KeyName,
      'Location', 0, InstallPath);
  end;
end;

end.
