#include "mainwindow.h"
#include "mdiwindow.h"
#include "include/key.h"

#include <qmenubar.h>

void 
MainWindow::slot_key(int)
{
	MDIWindow* s = new MDIWindow(workspace, 0, WDestructiveClose);
	  
	s->setFixedSize(510, 303 + 25);
	
	KeyManager *key = new KeyManager(&mysql, s);

	connect(key, SIGNAL(signal_schema()), this, SLOT(slot_schema()));
	
    s->setCentralWidget(key);
			 
    s->setCaption(tr("Key"));

	QPopupMenu *z = new QPopupMenu();
	z->insertItem(tr("&Fire"), key, SLOT(slot_fire()), Key_F5);
	z->insertSeparator();	
	z->insertItem(tr("Cl&ose"), key, SLOT(slot_close()));
	s->menuBar()->insertItem(tr("&File"), z);
	
	z = new QPopupMenu();
	z->insertItem(tr("&New"), key, SLOT(slot_new()));
	z->insertItem(tr("&Save"), key, SLOT(slot_save()));
	z->insertItem(tr("&Drop"), key, SLOT(slot_drop()));
	z->insertSeparator();
	z->insertItem(tr("Cl&ear"), key, SLOT(slot_clear()));
	s->menuBar()->insertItem(tr("&Tools"), z);

	//z = new QPopupMenu();
	//z->insertItem(tr("&About..."), key, SLOT(slot_about()), Key_F1);
	//s->menuBar()->insertItem(tr("&Help"), z);

	s->show();
}

void 
MainWindow::slot_key(const QString &database, const QString &table)
{
	MDIWindow* s = new MDIWindow(workspace, 0, WDestructiveClose);
	  
	s->setFixedSize(510, 303 + 25);
	
	KeyManager *key = new KeyManager(&mysql, s);

	connect(key, SIGNAL(signal_schema()), this, SLOT(slot_schema()));
	
	key->slot_value(database, table);

    s->setCentralWidget(key);
			 
    s->setCaption(tr("Key"));

	QPopupMenu *z = new QPopupMenu();
	z->insertItem(tr("&Fire"), key, SLOT(slot_fire()), Key_F5);
	z->insertSeparator();	
	z->insertItem(tr("Cl&ose"), key, SLOT(slot_close()));
	s->menuBar()->insertItem(tr("&File"), z);
	
	z = new QPopupMenu();
	z->insertItem(tr("&New"), key, SLOT(slot_new()));
	z->insertItem(tr("&Save"), key, SLOT(slot_save()));
	z->insertItem(tr("&Drop"), key, SLOT(slot_drop()));
	z->insertSeparator();
	z->insertItem(tr("Cl&ear"), key, SLOT(slot_clear()));
	s->menuBar()->insertItem(tr("&Tools"), z);

	//z = new QPopupMenu();
	//z->insertItem(tr("&About..."), key, SLOT(slot_about()), Key_F1);
	//s->menuBar()->insertItem(tr("&Help"), z);

	s->show();
}