#include "xonfigure.h"

#include <qlineedit.h>
#include <qcheckbox.h>
#include <qpushbutton.h>
#include <qspinbox.h>

void Xonfigure::signal_connect()
{
	connect((const QObject *)fire, SIGNAL(clicked()), (const QObject *)this, SLOT(slot_fire()));
	connect((const QObject *)close, SIGNAL(clicked()), (const QObject *)this, SLOT(slot_close()));
	connect((const QObject *)apply, SIGNAL(clicked()), (const QObject *)this, SLOT(slot_apply()));
	connect((const QObject *)log_button, SIGNAL(clicked()), (const QObject *)this, SLOT(slot_log_file()));
	connect((const QObject *)background_button, SIGNAL(clicked()), (const QObject *)this, SLOT(slot_background_file()));
	connect((const QObject *)log_flag, SIGNAL(clicked()), (const QObject *)this, SLOT(slot_log_flag()));
	connect((const QObject *)background_flag, SIGNAL(clicked()), (const QObject *)this, SLOT(slot_background_flag()));
	connect((const QObject *)password_flag, SIGNAL(clicked()), (const QObject *)this, SLOT(slot_password_flag()));
	connect((const QObject *)schema_flag, SIGNAL(clicked()), (const QObject *)this, SLOT(slot_schema_flag()));
}

void Xonfigure::slot_flag(struct __global__ *global)
{
	this->global = global;

	log_flag->setChecked(global->log.flag);
	log_file->setText(global->log.file);

	if(global->log.flag == FALSE)
	{
		log_file->setEnabled(FALSE);
		log_button->setEnabled(FALSE);
	}

	background_flag->setChecked(global->background.flag);
	background_file->setText(global->background.file);

	if(global->background.flag == FALSE)
	{
		background_file->setEnabled(FALSE);
		background_button->setEnabled(FALSE);
	}

	schema_flag->setChecked(global->schema.flag);
	password_flag->setChecked(global->password.flag);

	escape_flag->setChecked(global->query.flag);

	limit->setValue(global->limit);
}
