#include <qpushbutton.h>
#include <qmessagebox.h>
#include <qlineedit.h>
#include <qpopupmenu.h>

#include "process.h"
#include "multilinelistviewitem.h"

void Process::slot_kill(QListViewItem *process)
{
	if(process == NULL)
	{
		return;
	}
		
	QPopupMenu *l = new QPopupMenu(this);

	l->insertItem(tr("&Kill process"), this, SLOT(slot_kill(int)), 0, (int)process);

	l->popup(QCursor::pos());
}

void Process::slot_close()
{
	parentWidget()->close();
}

void Process::slot_kill(int process)
{
	int l = QMessageBox::warning (this, tr("MySQL Navigator"), tr("Do you want to kill process ") + ((QListViewItem *)process)->text(0) + "?", tr("Yes"), tr("No"));

    if(l == 0)
    {
		if(mysql_kill(mysql,((QListViewItem *)process)->text(0).toInt()))
		{
			emit signal_error();
			QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(mysql)));
			return; 	 
		}
		else
		{
			this->process->clear();
			slot_process();
		}
	}
	else
	{
	}
}

void Process::slot_about()
{
	QMessageBox::information(this, tr("MySQL Navigator"), tr("This is a process window."));
}

void Process::slot_kill()
{
	if(process->selectedItem() == NULL)
	{
		return;
	}

	slot_kill((int)(process->selectedItem()));
}

void Process::slot_refresh()
{
	slot_process();
}

void Process::slot_process()
{
	MYSQL_RES *result;
	MYSQL_FIELD *field;
	MYSQL_ROW row;

	process->clear();

	int si_;

	si_ = process->columns();

	for(int i = 0; i < si_; i++)
	{
		process->removeColumn(0);
	}

	mysql_select_db(mysql, "mysql");

	if(mysql_query(mysql, "show processlist"))
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(mysql)));
		return; 	 
	}

	result = mysql_store_result(mysql);

	if(result == NULL)
	{
		return;
	}
	
	si_ = mysql_num_fields(result);

	while((field = mysql_fetch_field(result)))
	{
		process->addColumn(field->name);
	}

	QListViewItem *si;
	
	while((row = mysql_fetch_row(result)))
	{
		//si = new QListViewItem(process, row[0]);
		si = new MultiLineListViewItem(process, row[0]);
		((MultiLineListViewItem *)si)->set_height(19);
	
		for(int _si = 1; _si < si_; _si++)
		{
			si->setText(_si, row[_si]);
		}
	}

	mysql_free_result(result);
}
