#include <qmenubar.h>
#include <qpopupmenu.h>
#include <qlistview.h>

#include "mainwindow.h"
#include "mdiwindow.h"
#include "table.h"

void MainWindow::slot_table()
{
	if(!flag)
	{
		return;	
	}
		
	MDIWindow* window = new MDIWindow(work_space, 0, WDestructiveClose);

	window->setFixedSize(480, 390);
	
	Table *table = new Table(&mysql, window);

	connect(table, SIGNAL(signal_error()), this, SLOT(slot_error()));
	connect(table, SIGNAL(signal_schema()), this, SLOT(slot_schema()));
	connect(this, SIGNAL(signal_schema()), table, SLOT(slot_database()));

    window->setCentralWidget(table);
			 
    window->setCaption(tr("Table"));

	QPopupMenu *l = new QPopupMenu();
	l->insertItem(tr("&Fire"), table, SLOT(slot_fire()), CTRL+Key_F);
	l->insertItem(tr("&Close"), table, SLOT(slot_close()), CTRL+Key_C);
	window->menuBar()->insertItem(tr("&File"), l);
	
	l = new QPopupMenu();
	l->insertItem(tr("&About..."), table, SLOT(slot_about()), Key_F1);
	window->menuBar()->insertItem(tr("&Help"), l);

	window->show();
}

void MainWindow::slot_table(const QString &database)
{
	if(!flag)
	{
		return;	
	}
		
	MDIWindow* window = new MDIWindow(work_space, 0, WDestructiveClose);

	window->setFixedSize(480, 390);
	
	Table *table = new Table(&mysql, window);

	table->slot_current_database(database);

	connect(table, SIGNAL(signal_error()), this, SLOT(slot_error()));
	connect(table, SIGNAL(signal_schema()), this, SLOT(slot_schema()));
	connect(this, SIGNAL(signal_schema()), table, SLOT(slot_database()));

    window->setCentralWidget(table);
			 
    window->setCaption(tr("Table"));

	QPopupMenu *l = new QPopupMenu();
	l->insertItem(tr("&Fire"), table, SLOT(slot_fire()), CTRL+Key_F);
	l->insertItem(tr("&Close"), table, SLOT(slot_close()), CTRL+Key_C);
	window->menuBar()->insertItem(tr("&File"), l);
	
	l = new QPopupMenu();
	l->insertItem(tr("&About..."), table, SLOT(slot_about()), Key_F1);
	window->menuBar()->insertItem(tr("&Help"), l);

	window->show();
}
