#include "mainwindow.h"
#include <qmessagebox.h>
#include <qlistview.h>
#include <qinputdialog.h>

void MainWindow::slot_table_records(int)
{
	slot_query(((QListViewItem *)dummy)->parent()->text(0), QString("select * from ") + ((QListViewItem *)dummy)->text(0), tr("Table"));
}

void MainWindow::slot_table_keys(int)
{
	slot_query(((QListViewItem *)dummy)->parent()->text(0), QString("show keys from ") + ((QListViewItem *)dummy)->text(0), tr("Keys"));
}

void MainWindow::slot_table_fields(int)
{
	slot_query(((QListViewItem *)dummy)->parent()->text(0), QString("show fields from ") + ((QListViewItem *)dummy)->text(0), tr("Fields"));
}

void MainWindow::slot_table_status(int)
{
	slot_query(((QListViewItem *)dummy)->parent()->text(0), QString("show table status like \'") + ((QListViewItem *)dummy)->text(0) + QString("\'"), tr("Status"));
}

void MainWindow::slot_create_table(int)
{
	QListViewItem *database = (QListViewItem *)dummy;
	slot_table(database->text(0));
}

void MainWindow::slot_rename_table(int)
{
	QListViewItem *table = (QListViewItem *)dummy;

	if(table == NULL)
	{
		return;
	}

	QString sql = table->text(0);
	QString database = table->parent()->text(0);

	if(database == QString("mysql"))
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), tr("Table in mysql database cannot be renamed."));
		return;
	}

	if(mysql_select_db(&mysql, database.latin1()))
	{
		slot_error();
		return;
	}

	bool l = FALSE;
	
	QString target = QInputDialog::getText(tr("MySQL Navigator"), tr("Please enter table name you will rename."), sql, &l, this );
	
	if(l && !target.isEmpty())
	{
	}
	else
	{
		return;
	}

	QString query;

	query.sprintf("rename table %s to %s", sql.latin1(), target.latin1());

	l = QMessageBox::warning (this, tr("MySQL Navigator"), tr("Do you really want to rename this table?"), tr("Yes"), tr("No"));
		
	if(l == 1)
	{
		return;
	}

	if((mysql_query(&mysql, query.latin1())))
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(&mysql)));
		slot_error();
	}
	else
	{
		//emit signal_schema();
		dummy->setText(0, target);
		QMessageBox::information(this, tr("MySQL Navigator"), QString(tr("Table ")) + sql + "@" + database + QString(tr(" is successfully renamed.")));
		mysql_reload(&mysql);
	}
}

void MainWindow::slot_delete_table(int)
{
	QListViewItem *table = (QListViewItem *)dummy;

	if(table == NULL)
	{
		return;
	}

	QString sql = table->text(0);
	QString database = table->parent()->text(0);

	if(database == QString("mysql"))
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), tr("Table in mysql database cannot be deleted"));
		return;
	}

	if(mysql_select_db(&mysql, database.latin1()))
	{
		slot_error();
		return;
	}

	QString query;

	query.sprintf("drop table %s", sql.latin1());

	int l = QMessageBox::warning (this, tr("MySQL Navigator"), tr("Do you really want to delete this table?"), tr("Yes"), tr("No"));
		
	if(l == 1)
	{
		return;
	}

	if((mysql_query(&mysql, query.latin1())))
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(&mysql)));
		slot_error();
	}
	else
	{
		//emit signal_schema();
		delete dummy;
		QMessageBox::information(this, tr("MySQL Navigator"), QString(tr("Table ")) + sql + "@" + database + QString(tr(" is successfully deleted.")));
		mysql_reload(&mysql);
	}
}

void MainWindow::slot_truncate_table(int)
{
	QListViewItem *table = (QListViewItem *)dummy;

	if(table == NULL)
	{
		return;
	}

	QString sql = table->text(0);
	QString database = table->parent()->text(0);

	if(database == QString("mysql"))
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), tr("Table in mysql database cannot be truncated."));
		return;
	}

	if(mysql_select_db(&mysql, database.latin1()))
	{
		slot_error();
		return;
	}

	QString query;

	query.sprintf("delete from %s", sql.latin1());

	int l = QMessageBox::warning (this, tr("MySQL Navigator"), tr("Do you really want to truncate this table?"), tr("Yes"), tr("No"));
		
	if(l == 1)
	{
		return;
	}

	if((mysql_query(&mysql, query.latin1())))
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(&mysql)));
		slot_error();
	}
	else
	{
		emit signal_schema();
		QMessageBox::information(this, tr("MySQL Navigator"), QString(tr("Table ")) + sql + "@" + database + QString(tr(" is successfully truncated.")));
		mysql_reload(&mysql);
	}
}

void MainWindow::slot_optimize()
{
	slot_query(((QListViewItem *)dummy)->parent()->text(0), QString("optimize table ") + ((QListViewItem *)dummy)->text(0), tr("Table"));
}

void MainWindow::slot_check_normal()
{
	slot_query(((QListViewItem *)dummy)->parent()->text(0), QString("check table ") + ((QListViewItem *)dummy)->text(0), tr("Table"));
}

void MainWindow::slot_check_quick()
{
	slot_query(((QListViewItem *)dummy)->parent()->text(0), QString("check table ") + ((QListViewItem *)dummy)->text(0) + QString(" type = quick"), tr("Table"));
}

void MainWindow::slot_ckeck_fast()
{
	slot_query(((QListViewItem *)dummy)->parent()->text(0), QString("check table ") + ((QListViewItem *)dummy)->text(0) + QString(" type = fast"), tr("Table"));
}

void MainWindow::slot_check_changed()
{
	slot_query(((QListViewItem *)dummy)->parent()->text(0), QString("check table ") + ((QListViewItem *)dummy)->text(0) + QString(" type = changed"), tr("Table"));
}

void MainWindow::slot_check_extended()
{
	slot_query(((QListViewItem *)dummy)->parent()->text(0), QString("check table ") + ((QListViewItem *)dummy)->text(0) + QString(" type = extended"), tr("Table"));
}

void MainWindow::slot_analyze()
{
	slot_query(((QListViewItem *)dummy)->parent()->text(0), QString("analyze table ") + ((QListViewItem *)dummy)->text(0), tr("Table"));
}

void MainWindow::slot_repair_normal()
{
	slot_query(((QListViewItem *)dummy)->parent()->text(0), QString("repair table ") + ((QListViewItem *)dummy)->text(0), tr("Table"));
}

void MainWindow::slot_repair_quick()
{
	slot_query(((QListViewItem *)dummy)->parent()->text(0), QString("repair table ") + ((QListViewItem *)dummy)->text(0) + QString(" type = quick"), tr("Table"));
}
