#include <qmessagebox.h>
#include <qinputdialog.h>
#include <qmenubar.h>
#include <qpopupmenu.h>

#include "mainwindow.h"
#include "mdiwindow.h"
#include "schema.h"
#include "field.h"

void MainWindow::slot_schema_clicked(QListViewItem *l)
{
	if(l == NULL)
	{
		return;
	}

	bool flag;

	flag = l->isOpen();

	switch(slot_type(l))
	{
		case 0:
			slot_query("", "show databases", "");
			break;
		case 1:
			slot_query("", QString("show tables from ") + l->text(0) , "");
			break;
		case 2:
			slot_query(l->parent()->text(0), QString("select * from ") + l->text(0) + " limit " + QString::number(global.limit), "");
			break;
		case 3:
			break;
	}

	l->setOpen(!flag);
}

void MainWindow::slot_schema_clicked(QListViewItem *se, const QPoint &, int)
{
	if(se == NULL)
	{
		return;
	}

	QPopupMenu *l = new QPopupMenu(this);
		
	switch(slot_type(se))
	{
		case 0:
		{
			// host	
			l->insertItem(tr("Refresh"), this, SLOT(slot_schema(int)));	
			l->insertSeparator();	
			
			QPopupMenu *x = new QPopupMenu();	
			x->insertItem(tr("hosts"), this, SLOT(slot_flush_hosts(int)));
			x->insertItem(tr("logs"), this, SLOT(slot_flush_logs(int)));
			x->insertItem(tr("status"), this, SLOT(slot_flush_status(int)));
			x->insertItem(tr("tables"), this, SLOT(slot_flush_tables(int)));
			x->insertItem(tr("privileges"), this, SLOT(slot_flush_privileges(int)));
			l->insertItem(tr("Flush"), x);	
			l->insertSeparator();	
			x = new QPopupMenu();	
			x->insertItem(tr("ping"), this, SLOT(slot_ping()));	
			x->insertItem(tr("status"), this, SLOT(slot_status()));	
			x->insertItem(tr("variable"), this, SLOT(slot_variable()));	
			x->insertItem(tr("shutdown"), this, SLOT(slot_shutdown()));	
			l->insertItem(tr("Server"), x);	
			l->insertSeparator();	
			l->insertItem(tr("Create database"), this, SLOT(slot_create_database(int)));	
			dummy = se;
			
			break;
		}
		case 1:
		{
			// database
			l->insertItem(tr("Delete database"), this, SLOT(slot_delete_database(int)));	
			l->insertSeparator();	
			l->insertItem(tr("Create table"), this, SLOT(slot_create_table(int)));	
			dummy = se;

			break;
		}
		case 2:
		{
			// table
			QPopupMenu *x;

			//x = new QPopupMenu;
			l->insertItem(tr("Keys in table"),this,SLOT(slot_table_keys(int)));	
			l->insertItem(tr("Fields in table"), this,SLOT(slot_table_fields(int)));	
			l->insertItem(tr("Status in table"),this,SLOT(slot_table_status(int)));	
			l->insertItem(tr("Record in table"),this,SLOT(slot_table_records(int)));	
			//l->insertItem(tr("Table"), x);	
			l->insertSeparator();
			l->insertItem(tr("Delete table"), this, SLOT(slot_delete_table(int)));	
			l->insertItem(tr("Rename table"), this, SLOT(slot_rename_table(int)));	
			l->insertItem(tr("Truncate table"), this, SLOT(slot_truncate_table(int)));	
			l->insertSeparator();
			l->insertItem(tr("Optimize table"), this, SLOT(slot_optimize()));
			x = new QPopupMenu;
			x->insertItem(tr("normal"), this, SLOT(slot_check_normal())); 
			x->insertItem(tr("quick"), this, SLOT(slot_check_quick()));
			x->insertItem(tr("fast"), this, SLOT(slot_ckeck_fast()));
			x->insertItem(tr("changed"), this, SLOT(slot_check_changed()));
			x->insertItem(tr("extended"), this, SLOT(slot_check_extended()));
			l->insertItem(tr("Check table"), x);
			
			l->insertItem(tr("Analyze table"), this, SLOT(slot_analyze()));
			x = new QPopupMenu;
			x->insertItem(tr("normal"), this, SLOT(slot_repair_normal()));
			x->insertItem(tr("quick"), this, SLOT(slot_repair_quick()));
			l->insertItem(tr("Repair table"), x);
			l->insertSeparator();

			l->insertItem(tr("Create field"), this, SLOT(slot_create_field(int)));
			dummy = se;
			break;

		}
		case 3:
		{
			l->insertItem(tr("Delete field"), this, SLOT(slot_delete_field(int)));
			l->insertItem(tr("Change field"), this, SLOT(slot_change_field(int)));
			l->insertItem(tr("Modify field"), this, SLOT(slot_modify_field(int)));
			l->insertSeparator();	
			l->insertItem(tr("Delete primary"), this, SLOT(slot_delete_primary(int)));
			l->insertItem(tr("Delete index"), this, SLOT(slot_delete_index(int)));
			l->insertSeparator();	
			l->insertItem(tr("Create primary"), this, SLOT(slot_create_primary(int)));
			l->insertItem(tr("Create unique"), this, SLOT(slot_create_unique(int)));
			l->insertItem(tr("Create index"), this, SLOT(slot_create_index(int)));
			dummy = se;
			break;
		}
	}

	l->popup(QCursor::pos());
}

void MainWindow::slot_schema_window()
{
	if(flag == FALSE)
		return;
	
	MDIWindow* window = new MDIWindow(work_space, 0, WDestructiveClose);
	
	Schema *schema= new Schema(&mysql, host, user, window);

	connect((QListView *)schema,SIGNAL(rightButtonClicked(QListViewItem *, const QPoint &, int)),this,SLOT(slot_schema_clicked(QListViewItem *, const QPoint &, int)));
	connect((QListView *)schema,SIGNAL(doubleClicked(QListViewItem *)),this,SLOT(slot_schema_clicked(QListViewItem *)));

	connect(this, SIGNAL(signal_schema()), schema, SLOT(slot_schema()));

	schema->slot_schema();

	window->setCentralWidget(schema);
	
	window->setCaption(tr("Schema"));

	window->resize(200,work_space->height()-25);
	
	window->show();
}

void MainWindow::slot_schema()
{
	slot_database();
	emit signal_schema();
}

void MainWindow::slot_schema(int)
{
	slot_schema();
}
