#include <qpopupmenu.h>
#include <qvbox.h>
#include <qlabel.h>
#include <qtooltip.h>
#include <qmenubar.h>
#include <qmessagebox.h>
#include <qvaluelist.h>
#include <qpixmap.h>
#include <qwindowsstyle.h>
#include <qmotifstyle.h>
#include <qmotifplusstyle.h>
#include <qcdestyle.h>
#include <qplatinumstyle.h>
#include <qfontdialog.h>
#include <qfont.h>
#include <qstatusbar.h>
#include <qmessagebox.h>
#include <mysql.h>

#include "mdiwindow.h"
#include "mainwindow.h"
#include "resource.h"

#include "user.h"
#include "table.h"
#include "script.h"
#include "edit.h"
#include "log.h"
#include "about.h"
#include "query.h"

#include <stdio.h>
#include <stdlib.h>

void MainWindow::slot_disconnect()
{
	if(!flag)
	{
		return;
	}

	save_history();

	statusBar()->message(tr("Disconnected..."), 3000);

	mysql_close(&mysql);	

	flag = FALSE;

	slot_close_windows();

	database->clear();

	query->clear();

	disable_menu();
}

void MainWindow::slot_exit()
{
	if(flag)
	{
		slot_disconnect();
	}
	
	close(TRUE);
}

bool MainWindow::slot_database()
{
	MYSQL_RES *result;
	MYSQL_ROW row; 
	
	database->clear();

	result = mysql_list_dbs(&mysql, NULL);

	if(result == NULL)
	{
		return FALSE;
	}

	while((row = mysql_fetch_row(result)))
	{
		database->insertItem(row[0]);
	}

	mysql_free_result(result);

	return TRUE;
}

void MainWindow::slot_display_background()
{
	if(global.background.flag)
	{
		work_space->setBackgroundPixmap(QPixmap(global.background.file));
		emit signal_display_background(global.background.file);
	}
		
	else
	{
		work_space->setBackgroundPixmap(QPixmap(""));
		emit signal_display_background("");
	}
}

void MainWindow::slot_workspace_clicked()
{
	if(flag == FALSE)
		return;

	QPopupMenu *l = new QPopupMenu();

	l->setCaption(tr("MySQL"));	
	//l->insertTearOffHandle(TOOLBAR_TEAROFF);	
	l->insertItem(tr("&Schema"),this,SLOT(slot_schema_window()), 0, TOOLBAR_SCHEMA);
	l->insertItem(tr("&User"),this,SLOT(slot_user(int)), 0, TOOLBAR_USER);	
	l->insertItem(tr("&Privilege"),this,SLOT(slot_privilege()), 0, TOOLBAR_PRIVILEGE);	
	l->insertItem(tr("T&able"),this,SLOT(slot_table()), 0, TOOLBAR_TABLE);	
	l->insertItem(tr("&Query"),this,SLOT(slot_query_window()), 0, TOOLBAR_QUERY);
	l->insertItem(tr("&Process"),this,SLOT(slot_process()), 0, TOOLBAR_PROCESSLIST);
	l->insertItem(tr("&Xport"),this,SLOT(slot_xport()), 0, TOOLBAR_XPORT);
	//l->insertItem(tr("&Status"),this,SLOT(slot_status()), 0, TOOLBAR_STATUS);
	//l->insertItem(tr("&Variables"),this,SLOT(slot_variable()), 0, TOOLBAR_VARIABLES);
	l->insertItem(tr("P&assword"),this,SLOT(slot_password()), 0, TOOLBAR_PASSWORD);
	//l->insertItem(tr("P&ing"),this,SLOT(slot_ping()), 0, TOOLBAR_PING);

	l->insertItem(tr("&Script"),this,SLOT(slot_script_run()), 0, TOOLBAR_SCRIPT);
	l->insertItem(tr("&Edit"),this,SLOT(slot_script_edit()), 0, TOOLBAR_EDIT);
	l->insertItem(tr("&Flush"), this, SLOT(slot_flush()), 0, TOOLBAR_FLUSH);
	//l->insertItem(tr("&Shutdown"),this,SLOT(slot_shutdown()), 0, TOOLBAR_SHUTDOWN);
	l->popup(QCursor::pos());
}

void MainWindow::slot_terminal()
{
	QString language;

	language.sprintf("%s", getenv("LANG"));

	if(language.isEmpty())
	{
		system("xterm &");
	}
	else
	{
		if(language == QString("ko_KR.EUC") || language == QString("ko"))
		{
			system("hanterm &");
		}
		else
		{
			system("xterm &");
		}
	}
}

void MainWindow::slot_clear_history()
{
	clear_history();
}

void MainWindow::slot_save_history()
{
	save_history();
}
