#include "mainwindow.h"
#include "serverlistviewitem.h"
#include <qfile.h>
#include <stdio.h>
#include <stdlib.h>
#include <qdom.h>

void MainWindow::load_session()
{
	char buffer[100];

	sprintf(buffer, "%s/.mysqlnavigator.rc", getenv("HOME"));

	QFile l(buffer);

	if(l.exists() == FALSE)
	{
		return;
	}
	
	if(l.open(IO_ReadOnly) == FALSE)
	{
		return;
	}

	QDomDocument mysql("mysql");

	if(mysql.setContent(&l) == FALSE)
	{
		l.close();
		return;
	}

	l.close();

	QDomNodeList list;
	
	list = mysql.elementsByTagName("GLOBAL");
	if(list.count() != 0)
	{
		QDomNode node;

		node = list.item(0).namedItem("LOG");
		if(node.isElement())
		{
			global.log.flag = node.namedItem("FLAG").firstChild().nodeValue().toInt();
			global.log.file= node.namedItem("FILE").firstChild().nodeValue();
		}

		node = list.item(0).namedItem("BACKGROUND");
		
		if(node.isElement())
		{
			global.background.flag = node.namedItem("FLAG").firstChild().nodeValue().toInt();
			global.background.file= node.namedItem("FILE").firstChild().nodeValue();
		}
	
		node = list.item(0).namedItem("PASSWORD");
		if(node.isElement())
			global.password.flag = node.firstChild().nodeValue().toInt();
		
		node = list.item(0).namedItem("SCHEMA");
		if(node.isElement())
			global.schema.flag = node.firstChild().nodeValue().toInt();
		
		node = list.item(0).namedItem("QUERY");
		if(node.isElement())
			global.query.flag = node.firstChild().nodeValue().toInt();

		node = list.item(0).namedItem("LIMIT");
		if(node.isElement())
			global.limit = node.firstChild().nodeValue().toInt();

		//debug("log: %d, %s", global.log.flag, global.log.file.latin1());
	}
	
	list = mysql.elementsByTagName("STYLE");
	if(list.count() != 0)	
		global.style = atoi(list.item(0).firstChild().nodeValue());
	
	list = mysql.elementsByTagName("WIDTH");
	if(list.count() != 0)	
		global.size.setWidth(atoi(list.item(0).firstChild().nodeValue()));
	
	list = mysql.elementsByTagName("HEIGHT");
	if(list.count() != 0)	
		global.size.setHeight(atoi(list.item(0).firstChild().nodeValue()));

	/*
	list = mysql.elementsByTagName("SAVEPASSWORD");
	if(list.count() != 0)	
		password = atoi(list.item(0).firstChild().nodeValue());
	
	list = mysql.elementsByTagName("SHOWSCHEMA");
	if(list.count() != 0)	
		schema = atoi(list.item(0).firstChild().nodeValue());
	*/

	switch(global.style)
	{
		case 0:
			slot_windows();
			break;
		case 1:
			slot_cde();
			break;
		case 2:
			slot_motif();
			break;
		case 3:
			slot_motif_plus();
			break;
		case 4:
			slot_platinum();
			break;
		case 5:
			slot_sgi();
			break;
		case 6:
			slot_jfc();
			break;
		case 7:
			slot_nextstep();
			break;
		default:
			slot_windows();
			break;
	}
}

void MainWindow::save_session()
{
	QString buffer;

	buffer.append("<MYSQL>");
	
	buffer.append("<GLOBAL>");	
	buffer.append("<LOG>");	
	buffer.append("<FLAG>");	
	buffer.append(global.log.flag ? "1" : "0");	
	buffer.append("</FLAG>");	
	buffer.append("<FILE>");
	buffer.append(global.log.file.simplifyWhiteSpace());
	buffer.append("</FILE>");
	buffer.append("</LOG>");	
	buffer.append("<BACKGROUND>");	
	buffer.append("<FLAG>");	
	buffer.append(global.background.flag ? "1" : "0");	
	buffer.append("</FLAG>");	
	buffer.append("<FILE>");
	buffer.append(global.background.file.simplifyWhiteSpace());
	buffer.append("</FILE>");
	buffer.append("</BACKGROUND>");	
	buffer.append("<SCHEMA>");	
	buffer.append(global.schema.flag ? "1" : "0");	
	buffer.append("</SCHEMA>");	
	buffer.append("<PASSWORD>");	
	buffer.append(global.password.flag ? "1" : "0");	
	buffer.append("</PASSWORD>");	
	buffer.append("<QUERY>");	
	buffer.append(global.query.flag ? "1" : "0");	
	buffer.append("</QUERY>");	
	buffer.append("<LIMIT>");	
	buffer.append(QString::number(global.limit));	
	buffer.append("</LIMIT>");	
	
	buffer.append("</GLOBAL>");	
	
	buffer.append("<STYLE>");
	buffer.append(QString::number(global.style));
	buffer.append("</STYLE>");
	buffer.append("<SIZE>");
	buffer.append("<WIDTH>");
	buffer.append(QString::number(global.size.width()));
	buffer.append("</WIDTH>");
	buffer.append("<HEIGHT>");
	buffer.append(QString::number(global.size.height()));
	buffer.append("</HEIGHT>");
	buffer.append("</SIZE>");

	if(dialog == NULL)
	{
	}
	else
	{
		QListViewItemIterator l(dialog->list);

		for(; l.current(); ++l)
		{
			buffer.append("<SERVER>");
			buffer.append("<HOST>");
			buffer.append(((ServerListViewItem *)l.current())->host);
			buffer.append("</HOST>");
			buffer.append("<USER>");
			buffer.append(((ServerListViewItem *)l.current())->user);
			buffer.append("</USER>");
			buffer.append("<PASSWORD>");
			if(global.password.flag)	
				buffer.append(((ServerListViewItem *)l.current())->password);
			buffer.append("</PASSWORD>");
			buffer.append("<DATABASE>");
			buffer.append(((ServerListViewItem *)l.current())->database);
			buffer.append("</DATABASE>");
			buffer.append("<PORT>");
			buffer.append(((ServerListViewItem *)l.current())->port);
			buffer.append("</PORT>");
			buffer.append("<SOCKET>");
			buffer.append(((ServerListViewItem *)l.current())->socket);
			buffer.append("</SOCKET>");
			buffer.append("</SERVER>");
		}
	}
	buffer.append("</MYSQL>");

	//debug(buffer.latin1());

	char log[100];

	sprintf(log, "%s/.mysqlnavigator.rc", getenv("HOME"));

	QFile si(log);

	if(si.open(IO_WriteOnly | IO_Truncate) == FALSE)
	{
		//debug("open() system call fail.");
		return;
	}

	si.writeBlock(buffer, buffer.length());

	si.close();
}
