#include <qcombobox.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qmessagebox.h>

#include <string.h>

#include "field.h"

void Field::slot_close()
{
	parentWidget()->close();
}

void Field::slot_fire()
{
	QString sql;

	if(field->text().length() == 0)
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), tr("Please enter field name."));
		return;
	}

	if(value == field->text())
	{
		if(flag == FIELD_CHANGE)
		{
			QMessageBox::critical(this, tr("MySQL Navigator"), tr("Please enter another field name, because field name must be different from before one."));
			return;
		}
	}

	if(database->currentText() == QString("mysql"))
	{
		if(flag == FIELD_CREATE)
		{
			QMessageBox::critical(this, tr("MySQL Navigator"), tr("Field in mysql database can't be created."));
		}
		else if(flag == FIELD_CHANGE)
		{
			QMessageBox::critical(this, tr("MySQL Navigator"), tr("Field in mysql database can't be changed."));
		}
		else if(flag == FIELD_MODIFY)
		{
			QMessageBox::critical(this, tr("MySQL Navigator"), tr("Field in mysql database can't be modified."));
		}
		return;
	}

	if(mysql_select_db(mysql, database->currentText().latin1()))
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(mysql)));
		return;
	}

	if(flag == FIELD_CREATE)
	{
		sql += "ALTER TABLE ";
		sql += table->currentText();
		sql += " ADD ";
		sql += field->text();
		sql += " ";
	}
	else if(flag == FIELD_CHANGE)
	{
		sql += "ALTER TABLE ";
		sql += table->currentText();
		sql += " CHANGE ";
		sql += value;
		sql += " ";
		sql += field->text();
		sql += " ";
	}
	else if(flag == FIELD_MODIFY)
	{
		sql += "ALTER TABLE ";
		sql += table->currentText();
		sql += " MODIFY ";
		sql += field->text();
		sql += " ";

	}

	sql += type->currentText();

	if(length->text().length() == 0)
	{
		sql += " ";
	}
	else
	{
		sql += "(";
		sql += length->text();
		sql += ")";
		sql += " ";
	}

	if(binary->currentItem() != 0)
	{
		sql += binary->currentText();
		sql += " ";
	}

	if(null->currentText().contains("NOT"))
	{
		sql += null->currentText();
		sql += " ";
	}

	if(_default->text().length() != 0)
	{
		sql += "DEFAULT ";
		sql += "\'";
		sql += _default->text();
		sql += "\'";
		sql += " ";
	}

	if(extra->currentItem() != 0)
	{
		sql += extra->currentText();
		sql += " ";
	}

	if(flag == FIELD_CREATE)
	{
		if(position->currentItem() == 0)
		{
			sql += "FIRST";
			sql += " ";
		}
		else if(position->currentItem() == 1)
		{
		}
		else
		{
			sql += position->currentText();
			sql += " ";
		}
	}

	// 2001/05/05
	if(extra->currentItem() != 0)
	{
		sql += ", ";
		sql += "ADD INDEX (";
		sql += field->text();
		sql += ")";
	}

	//debug(sql.latin1());

	if(mysql_query(mysql, sql.latin1()))
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(mysql)));
		emit signal_error();
		return;
	}

	mysql_reload(mysql);
	emit signal_schema();

	if(flag == FIELD_CREATE)
	{
		QMessageBox::information(this, tr("MySQL Navigator"), QString(tr("Field ") + field->text() + QString(tr(" is successfully created.")))); 
	}
	else if(flag == FIELD_CHANGE)
	{
		QMessageBox::information(this, tr("MySQL Navigator"), QString(tr("Field ") + value + QString(tr(" is successfully changed.")))); 
	}
	else if(flag == FIELD_MODIFY)
	{
		QMessageBox::information(this, tr("MySQL Navigator"), QString(tr("Field ") + value + QString(tr(" is successfully modified.")))); 
	}
}

void Field::slot_about()
{
	QMessageBox::information(this, tr("MySQL Navigator"), tr("This is a field window."));
}

void Field::slot_clear()
{
	position->setCurrentItem(0);
	field->setText("");
	type->setCurrentItem(0);
	length->setText("");
	binary->setCurrentItem(0);
	null->setCurrentItem(0);
	_default->setText("");
	extra->setCurrentItem(0);

	position->setFocus();
}

void Field::slot_default_value()
{
	MYSQL_RES *result;
	MYSQL_ROW row;

	QString sql;

	if(mysql_select_db(mysql, database->currentText().latin1()))
		return;

	sql += "show fields from ";
	sql += table->currentText();

	//debug(sql.latin1());

	if(mysql_query(mysql, sql.latin1()))
		return;

	result = mysql_store_result(mysql);

	if(result == NULL)
		return;

	while((row = mysql_fetch_row(result)))
	{
		if(QString(row[0]) == value)
		{
			field->setText(row[0]);

			type->setCurrentItem(get_type(QString(row[1])));

			length->setText(get_length(QString(row[1])));

			if(QString(row[1]).contains("zerofill"))
			{
				binary->setCurrentItem(3);	
			}
			else if(QString(row[1]).contains("unsigned"))
			{
				binary->setCurrentItem(2);	
			}
			else if(QString(row[1]).contains("binary"))
			{
				binary->setCurrentItem(1);	
			}
							
			if(QString(row[2]) == QString("YES"))
				null->setCurrentItem(1);

			if(QString(row[4]).isEmpty() == FALSE)
				_default->setText(row[4]);

			if(QString(row[5]) == QString("auto_increment"))
				extra->setCurrentItem(1);				

			break;
		}
	}
	
	mysql_free_result(result);	

}

QString Field::get_length(QString type)
{
	QString sql;

	bool flag = FALSE;

	for(unsigned int l = 0; l < type.length(); l++)
	{
		if(flag)
		{
			if(type[l] != ')')
				sql += QChar(type[l]);
		}

		if(type[l] == '(')
			flag = TRUE;

		if(type[l] == ')')
		{
			break;
		}
	}

	//debug(sql.latin1());

	return sql;
}

int Field::get_type(QString sql)
{
	char type[25][20] = {"TINYINT", "SMALLINT", "MEDIUMINT", "INT", "BIGINT", "FLOAT", "DOUBLE", "DECIMAL", "DATE", "DATETIME", "TIMESTAMP", "TIME", "YEAR", "CHAR", "VARCHAR", "TINYBLOB", "TINYTEXT", "TEXT", "BLOB", "MEDIUMBLOB", "MEDIUMTEXT", "LONGBLOB", "LONGTEXT", "ENUM", "SET"};

	sql = sql.upper();

	for(int l = 0; l < 25; l++)
	{
		if(strncmp(sql.latin1(), type[l], strlen(type[l])) == 0)
		{
			//debug(type[l]);
			return l;
		}
	}

	return 0;
}

void Field::slot_database()
{
	MYSQL_RES *result;
	MYSQL_ROW row;

	database->clear();

	result = mysql_list_dbs(mysql,NULL);

	if(result == NULL)
	{
		return;
	}

	while((row = mysql_fetch_row(result)))
	{
		database->insertItem(row[0]);
	}

	mysql_free_result(result);
}

void Field::slot_table()
{
	MYSQL_RES *result;
	MYSQL_ROW row;

	table->clear();
	
	if(mysql_select_db(mysql, database->currentText().latin1()))
	{
		return;
	}

	result = mysql_list_tables(mysql, NULL);
	
	if(result == NULL)
	{
		return;
	}

	while((row = mysql_fetch_row(result)))
	{
		table->insertItem(row[0]);
	}

	mysql_free_result(result);

	slot_position();
}

void Field::slot_position()
{
	if(flag != FIELD_CREATE)
		return;

	position->clear();

	if(mysql_select_db(mysql, database->currentText().latin1()))
	{
		return;
	}

	result = mysql_list_fields(mysql, table->currentText().latin1(), NULL);

	if(result == NULL)
	{
		return;
	}

	MYSQL_FIELD *l;

	position->insertItem(tr("First of table"));
	position->insertItem(tr("Last of table"));

	while((l = mysql_fetch_field(result)))
	{
		position->insertItem(QString(QString("AFTER ") + QString(l->name)).latin1());
	}

	mysql_free_result(result);
}

void Field::slot_current_database(const QString &text)
{
	for(int l = 0; l < database->count(); l++)
		if(text == database->text(l))
		{
			database->setCurrentItem(l);
			break;
		}	
}

void Field::slot_current_table(const QString &text)
{
	for(int l = 0; l < table->count(); l++)
		if(text == table->text(l))
		{
			table->setCurrentItem(l);
			break;
		}	
}
