#ifndef EDIT_H
#define EDIT_H

#include <qmainwindow.h>
#include <qworkspace.h>
#include <qmultilineedit.h>

#include "file.h"

class Edit : public QMainWindow
{
Q_OBJECT

public:
	Edit(QWidget *, const char *, int);
	~Edit();

private:
	QWorkspace *work_space;

	void make_central_widget();
	void make_menubar();

private slots:
	void slot_new();
	void slot_open();
	void slot_save();
	void slot_save_as();
	void slot_print();
	void slot_close();
	void slot_quit();

	void slot_undo();
	void slot_redo();
	void slot_cut();
	void slot_copy();
	void slot_paste();
	void slot_paste_special();
	void slot_clear();
	void slot_select_all();

	void slot_about();

	void slot_message(const QString &, int);

protected:
	void closeEvent(QCloseEvent *);

public slots:
	void slot_display_background(const QString &);
};

#endif
