#include <unistd.h>
#include <qapplication.h>
#include <qlabel.h>
#include <qfont.h>
#include <qwindowsstyle.h>
#include <qplatinumstyle.h> 
#include <qmotifstyle.h>
#include <qcdestyle.h>
#include <qtranslator.h>
#include <qobject.h>

#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "mainwindow.h"
#include "resource.h"
#include "mdiwindow.h"

void echo_text(char *);

int main(int argc,char **argv)
{
	QApplication app(argc,argv);

	bool flag = FALSE;

	QString host;
	QString user;
	QString password;
	int port = 3306;
	QString database;
	QString socket;

	if(argc > 2)
	{
		for(int l = 1; l < argc; l++)
		{
			if(argv[l][0] != '-')
				continue;
			
			switch(argv[l][1])
			{
				case 'h':
					host = argv[l + 1];
					echo_text(argv[l + 1]);
					l++;
					break;
				case 'u':
					user = argv[l + 1];
					echo_text(argv[l + 1]);
					l++;
					break;
				case 'p':
					password = argv[l + 1];
					echo_text(argv[l + 1]);
					l++;
					break;
				case 'd':
					database = argv[l + 1];
					echo_text(argv[l + 1]);
					l++;
					break;
				case 'P':
					port = atoi(argv[l + 1]);
					echo_text(argv[l + 1]);
					l++;
					break;
				case 's':
					socket = argv[l + 1];
					echo_text(argv[l + 1]);
					l++;
					break;
			}
		}

		if(!host.isEmpty() && !user.isEmpty())
			flag = TRUE;
	}

	QTranslator translator(0);
	
	QString l;
	
	l.sprintf("%s", getenv("LANG"));

	QString buffer;
	buffer.sprintf("%s/po", MYSQL_NAVIGATOR_HOME);

	//debug(buffer);

	if(l.isEmpty())
	{
	}
	else
	{
		if(l== QString("ko_KR.EUC"))
		{
			translator.load("mysql_navigator_ko.qm", buffer);
			app.installTranslator(&translator);
		}
		else
		{
			translator.load(QString("mysql_navigator_") + l+ QString(".qm"), buffer); 
			app.installTranslator(&translator);
		}
	}

	app.setStyle(new QWindowsStyle());

	umask(077);

	MainWindow *mysql = new MainWindow(&app);

	mysql->setCaption(QObject::tr("MySQL Navigator 1.2.4"));
 	
	app.setMainWidget(mysql);

	mysql->show();
	
	if(flag)
	{
		mysql->connect_directly(host, user, password, database, port, socket);
	}

	return  app.exec();
}

void echo_text(char *text)
{
	for(unsigned int l = 0; l < strlen(text); l++)
		text[l] = '*';
}
