#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <mysql.h>
#include <qmainwindow.h>
#include <qtoolbar.h>
#include <qcombobox.h>
#include <qpopupmenu.h>
#include <qtabwidget.h>
#include <qsplitter.h>
#include <qtoolbutton.h>
#include <qapplication.h>
#include <qworkspace.h>
#include <qlineedit.h>
#include <qmap.h>

#include "connect.h"
#include "mainwindowglobal.h"
#include "xworkspace.h"

class MainWindow: public QMainWindow
{
Q_OBJECT

public:
	MainWindow(QApplication *);
	~MainWindow();

private slots:
	void slot_connect();
	void slot_connect_new();
	void slot_disconnect();
	void slot_exit();
	void slot_hide_toolbar();
	void slot_hide_statusbar();
	void slot_close_window();
	void slot_close_windows();
	void slot_windows();
	void slot_motif();
	void slot_motif_plus();
	void slot_cde();
	void slot_platinum();
	void slot_sgi();
	void slot_jfc();
	void slot_nextstep();
	void slot_schema_window();
	void slot_user(int);
	void slot_table();
	void slot_table(const QString &);
	void slot_query_window();
	void slot_process();
	void slot_xport();
	void slot_log();
	void slot_status();
	void slot_variable();
	void slot_password();
	void slot_ping();
	void slot_flush();
	void slot_flush_hosts();
	void slot_flush_logs();
	void slot_flush_privilages();
	void slot_flush_status();
	void slot_flush_tables();
	void slot_flush_threads();
	void slot_script_run();
	void slot_script_edit();
	void slot_terminal();
	void slot_clear_history();
	void slot_save_history();
	void about();
	void aboutQt();
	void slot_log(bool, const QString &);
	void slot_error();
	void slot_error(const QString &, const QString &);
	void slot_fire();
	void slot_close();
	void slot_query();
	void slot_create_database(int);
	void slot_delete_database(int);
	void slot_create_table(int);
	void slot_delete_table(int);
	void slot_delete_field(int);
	void slot_delete_primary(int);
	void slot_delete_index(int);
	void slot_delete_unique(int);
	void slot_create_primary(int);
	void slot_create_unique(int);
	void slot_create_index(int);
	void slot_create_field(int);
	void slot_change_field(int);
	void slot_modify_field(int);
	void slot_highlight(int);
	void slot_schema_clicked(QListViewItem *, const QPoint &, int);
	void slot_schema_clicked(QListViewItem *);
	void slot_table_records(int);
	void slot_table_keys(int);
	void slot_table_fields(int);
	void slot_table_status(int);
	void slot_query(const QString &, const QString &);
	void slot_query(const QString &, const QString &, const QString &);
	void slot_schema(int);		
	void slot_schema();
	void slot_flush_hosts(int);
	void slot_flush_logs(int);
	void slot_flush_status(int);
	void slot_flush_tables(int);
	void slot_flush_privileges(int);
	void slot_truncate_table(int);
	void slot_rename_table(int);
	bool slot_database();
	void slot_shutdown();
	void slot_privilege();
	void slot_xonfigure();
	void slot_display_background();
	void slot_workspace_clicked();
	int slot_type(QListViewItem *);
	void slot_find();
	void slot_optimize();
	void slot_check_normal();
	void slot_check_quick();
	void slot_ckeck_fast();
	void slot_check_changed();
	void slot_check_extended();
	void slot_analyze();
	void slot_repair_normal();
	void slot_repair_quick();

protected:
	virtual void closeEvent(QCloseEvent *);
	virtual void keyPressEvent(QKeyEvent *);
	virtual void resizeEvent(QResizeEvent *);

private:
	void make_layout();
	void make_central_widget();
	void make_toolbar();
	void make_menubar();
	void make_statusbar();
	void set_base_color(QWidget *,QColor);
	void set_background_color(QWidget *,QColor);
	void signal_connect();
	void load_session();
	void save_session();
	void enable_menu();
	void disable_menu();
	void load_history();
	void save_history();
	void clear_history();
	void load_server_list(Connect *);
	void make_connect_dialog();
	void initialize();
	bool is_exist_in_history(const QString &sql);

private:
	QToolBar *toolbar;
	QComboBox *database;
	QComboBox *query;
	XWorkspace *work_space;
	QApplication *application;
	QListViewItem *dummy; 
	Connect *dialog;

	bool flag;
	MYSQL mysql;
	QString host;
	QString user;
	struct __global__ global;

public:
	void connect_directly(const QString &host, const QString &user, const QString &password, const QString &database, const int &port, const QString socket);

signals:
	void signal_schema();
	void signal_display_background(const QString&);
};

#endif 
