#import "MWDocumentProperties.h"

@implementation MWDocumentProperties

- (id)initWithValue:(MGRTValue)value
{
  self= [super init];
  if (self)
  {
    _value= new MGRTValue(value);
    [NSBundle loadNibNamed:@"ModelProperties" owner:self];
  }
  return self;
}


- (void)awakeFromNib
{
  [[form cellWithTag:0] setStringValue:[NSString stringWithUTF8String:(*_value)["modelName"].asString()]];
  [[form cellWithTag:1] setStringValue:[NSString stringWithUTF8String:(*_value)["version"].asString()]];
  [[form cellWithTag:2] setStringValue:[NSString stringWithUTF8String:(*_value)["author"].asString()]];
  [[form cellWithTag:3] setStringValue:[NSString stringWithUTF8String:(*_value)["project"].asString()]];
  [[form cellWithTag:4] setStringValue:[NSString stringWithUTF8String:(*_value)["dateCreated"].asString()]];
  [[form cellWithTag:5] setStringValue:[NSString stringWithUTF8String:(*_value)["dateChanged"].asString()]];
  
  [description setString:[NSString stringWithUTF8String:_value->get("description", "")]];
}

- (IBAction)buttonClicked:(id)sender
{
  if ([sender tag] == 2)
  {
    _value->set("modelName", [[[form cellWithTag:0] stringValue] UTF8String]);
    _value->set("version", [[[form cellWithTag:1] stringValue] UTF8String]);
    _value->set("author", [[[form cellWithTag:2] stringValue] UTF8String]);
    _value->set("project", [[[form cellWithTag:3] stringValue] UTF8String]);
    _value->set("dateCreated", [[[form cellWithTag:4] stringValue] UTF8String]);
    _value->set("dateChanged", [[[form cellWithTag:5] stringValue] UTF8String]);
    
    _value->set("description", [[description string] UTF8String]);
  }
  [window close];
  [self release];
}


- (void)dealloc
{
  delete _value;
  [super dealloc];
}


@end
