/* Copyright (C) 2005 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

#ifndef _MYWB_H_
#define _MYWB_H_

#include "config.h"


#include "MWPreferences.h"


#include <libintl.h>

#ifdef ENABLE_NLS
# define _(s) gettext(s)
# define N_(s) s
#else
# define N_(s) s
# define _(s) s
#endif


extern MWPreferences prefs;


#define PATH_ENV "MWB_DIR"

extern std::string get_prefix();
extern std::string get_common_file(const std::string &file);
extern std::string get_libexec_file(const std::string &file);
extern std::string get_app_file(const std::string &file);

#endif /* _MYWB_H_ */
