/* Copyright (C) 2003, 2004 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

#include "mywb.h"

#include "MWMainWindow.h"
#include "myg_utils.h"
#include "myg_gtkutils.h"
#include "myx_grt_public_interface.h"

#include <gtkmm.h>

//#include "MWPreferencesEditor.h"

#include <string>

#include <errno.h>

#include <mysql.h>



// global
MWPreferences prefs;
pthread_t main_thread;

char **wb_argv= NULL;

static char *get_arg(char **argv, int index)
{
  char *arg= argv[index];
  char *ptr= strchr(arg,'=');
  if (ptr)
  {
    if (*(ptr+1)) /* --foo=bla */
      return ptr+1;
    else
      return NULL; /* --foo= */
  }
  else
  {
    if (strncmp(arg,"--",2)==0) /* --foo bla */
      return argv[index+1];
    else
    {
      if (strlen(arg)==2) /* -f bla */
        return argv[index+1];
      else
        return argv[index]+2; /* -fbla */
    }
  }
}


bool parse_cmd_line_args(int argc, char **argv)
{
//  char *value;
  int i;

#define CHECK_OPTION(s,v) (Glib::str_has_prefix(s,v"=") || strcmp(s,v)==0)
  
  for (i= 1; i < argc; i++)
  {
    if (argv[i][0]=='-')
    {
      g_print(_("%s: unknown option %s\n"), g_get_prgname(), argv[i]);
      return false;
    }
  }

  return true;

//missing_arg:
  g_print(_("%s: missing value for option %s\n"), g_get_prgname(), argv[i]);
  return false;
}


static void setup_preferences_editor()
{
  /*
  MGPreferencesEditor::setup(&prefs);
  MGPreferencesEditor *ed= MGPreferencesEditor::instance();
  MWPreferenceGroup *group= new MWPreferenceGroup();
  //ed->addGroup(group, _("Workbench"), PIXCACHE->load("MySQLIcon_Workbench_48x48.png"));
  
  ed->init();
   */
}


#ifdef ENABLE_GT
extern "C" {
void gt_init_testing();
};
#endif

int main(int argc, char **argv)
{
  wb_argv= argv;
  
  // force read of our custom style file
  Gtk::RC::add_default_file("workbench.rc");
  Gtk::RC::add_default_file(get_app_file("workbench.rc"));

  Gtk::Main app(argc, argv, true);

  main_thread= pthread_self();
  
#ifdef DEBUG
  g_log_set_always_fatal(G_LOG_LEVEL_CRITICAL);
#endif
  myx_grt_init_threads();
  
#ifdef ENABLE_GT
  gt_init_testing();
#endif

#ifdef ENABLE_NLS
  bindtextdomain(GETTEXT_PACKAGE, std::string(get_prefix()+DATADIRNAME"/locale").c_str());
  bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
  textdomain(GETTEXT_PACKAGE);
#endif

  if (!parse_cmd_line_args(argc, argv))
    return 1;

  if (!getenv(PATH_ENV))
  {
    g_print(_("You must start this program using mysql-workbench.\n"));
    exit(0);
  }

  // add search paths for images
  {
    std::string prefix= get_prefix()+DATADIRNAME"/mysql-gui";
    PIXCACHE->add_search_path(prefix+"/workbench");
    PIXCACHE->add_search_path(prefix+"/"+COMMONDIRNAME);
    PIXCACHE->add_search_path(prefix+"/"+COMMONDIRNAME+"/common");
    PIXCACHE->add_search_path(prefix+"/"+COMMONDIRNAME+"/grt/db");
    PIXCACHE->add_search_path(prefix+"/"+COMMONDIRNAME+"/grt/icons");
    PIXCACHE->add_search_path(prefix+"/"+COMMONDIRNAME+"/grt/icons/structs");
    PIXCACHE->add_search_path(prefix);
  }

  // set datadir for myx library
  myg_set_datadir(get_prefix()+DATADIRNAME+"/mysql-gui/"+COMMONDIRNAME);
  
  // load preferences
  prefs.load("mysqlwb_options.xml");

  // check app specific rc dir
  prefs.check_directory(prefs.build_path_to("workbench"), true);

  setup_preferences_editor();

  {
    MWMainWindow *mainw= MWMainWindow::create();

    if (!mainw)
    {
      g_error(_("Error initializing GUI"));
      return 1;
    }

    mainw->setup();

    if (argc > 1 && argv[argc-1][0]!='-')
      mainw->open_document(argv[argc-1]);
    else
      mainw->new_document();
    
    mainw->show();
    
    app.run();
  }
  return 0;
}




std::string get_prefix()
{
  if (getenv(PATH_ENV))
    return std::string(getenv(PATH_ENV))+"/";
  else
    return PREFIX"/";
}


std::string get_common_file(const std::string &file)
{
  return Glib::build_filename(get_prefix(), DATADIRNAME"/mysql-gui/"COMMONDIRNAME"/"+file);
}


std::string get_libexec_file(const std::string &file)
{
  return Glib::build_filename(get_prefix(), "lib/mysql-gui/"COMMONDIRNAME"/"+file);
}


std::string get_app_file(const std::string &file)
{
  return Glib::build_filename(get_prefix(), DATADIRNAME"/mysql-gui/workbench/"+file);
}
