// oss_converter.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/

#ifdef OSS

#ifndef OSS_CONVERTER_H
#ifdef __GNUG__
#pragma interface
#endif
#define OSS_CONVERTER_H

#include "conv_device.h"

class HWMixer;
class String;

class OSS_Converter : public ConverterDevice {
	typedef ConverterDevice Super;
public:
	OSS_Converter();
	virtual ~OSS_Converter();
	redefined int pause();
	redefined int stop();
	redefined DataType bestPlayableType();
protected:
	redefined int extraOpenFlags();
	redefined boolean isPlayableFormat(DataType type);
	redefined int currentPlayLevel() const;
	redefined int currentRecordLevel() const;
	redefined boolean setPlayLevel(int volume);
	redefined boolean setRecordLevel(int volume);
	int currentInputDevice();
	int currentOutputDevice();
	boolean setInputDevice(int);
	boolean setOutputDevice(int);
	ChoiceValue inputDeviceToChoice(int);
	ChoiceValue outputDeviceToChoice(int);
	int inputChoiceToDevice(ChoiceValue);
	int outputChoiceToDevice(ChoiceValue);
	void getInputDeviceLabels(String &);
	void getOutputDeviceLabels(String &);
	redefined int doConfigure();					// hardware-specific
	redefined int checkChannels(int chans);
	redefined int writeSize();						// buffer size in bytes
	redefined int readSize();						// buffer size in bytes
	redefined int waitForStop(ProgressAction *);
	class OSS_ConfigRequester : public RealConverter::ConfigRequester {
	public:
	    OSS_ConfigRequester(RealConverter* cnverter) : ConfigRequester(cnverter) {}
	protected:
	    redefined void configureRequest(Request *);
	    redefined boolean confirmValues();
	private:
	    ChoiceValue inputDeviceValue;
	    ChoiceValue outputDeviceValue;
	};
	friend void OSS_ConfigRequester::configureRequest(Request *);
	friend boolean OSS_ConfigRequester::confirmValues();
	redefined Requester* configRequester();
private:
	OSS_Converter(const OSS_Converter &);
private:
        static int _openFlags;
	static char *_deviceLabels[];
	HWMixer *_mixer;
	unsigned audioFormatBits;
	int audioBufferSize;
};

#endif

#endif	/* OSS */
