// sgi_dac.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// Converter subclass for the Silicon Graphics Indy and Indigo workstation
// D-to-A converters.

#ifndef SGI_DAC_H
#ifdef __GNUG__
#pragma interface
#endif
#define SGI_DAC_H

extern "C" {
#include <audio.h>
#include <audiofile.h>
}

#include "converter.h"
#include "localdefs.h"

class Action;
class ProgressAction;

class SGIConverter : public RealConverter {
	typedef RealConverter Super;
public:
	enum InputSource { Mike = 0x1, Line = 0x2, Digital = 0x4 };
	SGIConverter();
	virtual ~SGIConverter();
	redefined int configure(Sound *sound, GoingTo);
	redefined int pause();
	redefined int resume();
	redefined int stop();
	redefined int currentPlayLevel() const;
	redefined int currentRecordLevel() const;
	redefined boolean setPlayLevel(int volume);
	redefined boolean setRecordLevel(int volume);
	redefined boolean setSpeakerOutput(boolean);
	redefined DataType bestPlayableType() { return ShortData; }
	int setInputSource(InputSource);
protected:
	redefined boolean isPlayableFormat(DataType type);
	redefined int doConfigure();
	redefined int doConversion(ProgressAction* askedToStop);
	redefined int doRecording(ProgressAction* askedToStop);
	redefined int waitForStop(ProgressAction *);
	redefined int checkSampleRate(int rate);
	redefined int checkChannels(int chans);
	redefined int checkDataType(DataType);
	redefined void catchSignals(boolean);
	redefined void ignoreSignals(boolean);
	InputSource currentInputSource();
	class SGIConfigRequester : public RealConverter::ConfigRequester {
	public:
		SGIConfigRequester(RealConverter* cvtr) : ConfigRequester(cvtr) {}
	protected:
		redefined void configureRequest(Request *);
		redefined boolean confirmValues();
	private:
		ChoiceValue source;
		ChoiceValue polite;
	};
	friend void SGIConfigRequester::configureRequest(Request *);
	redefined Requester* configRequester() {
		return new SGIConfigRequester(this);
	}
	friend class Controller;
private:
	int getDefaults();
	void resetDefaults();
	int initialize();
	int displayError();
	int sampleSize();			// size of each sample in bytes
	long bestQueueSize();		// converter queue size in samples
	long writeSamps();			// size of write buffer in samples
	long readSamps();			// size of read buffer in samples
	char* convertToSigned(char *, char*, long);	// converts unsigned chars to signed
	long getParameter(long param) const;
	int setParameter(long param, long value);
	int lockMemory();
	int unlockMemory();
private:
	static void signalExit(...);
	static void signalIgnore(...);
	static void signalQuit(...);
private:
	long pvbuf[16];
	ALconfig audio_port_config;
	ALport audio_port;
	static char* errorStrings[];
	static boolean dontInterrupt;	// true: do not play if cvtr in use
};

#endif

