/***************************************************************************
                          gnudirector.h  -  description
                             -------------------
    begin                : Sat Sep 1 2001
    copyright            : (C) 2001 by
    email                : maksik@gmx.co.uk
 ***************************************************************************/

// the original version of this file was taken from Gnucleus (http://gnucleus.sourceforge.net)

#if !defined(__GNUDIRECTOR_H_INCLUDED__)
#define __GNUDIRECTOR_H_INCLUDED__

#include "gnuhash.h"
#include "controller.h"

struct key_Value;

class MController;
class MGnuPreferences;
class MGnuSock;
class MGnuNode;
class MGnuDownload;
class MGnuUpload;
class MGnuCache;
class MGnuShare;
class MGnuSearch;

struct QueuedHit
{
	int   size;
	char* pPacket;
	MGnuNode *pNode;
};

class MGnuDirector : public MAsyncSocket
{
public:
	MGnuDirector(MController*);
	virtual ~MGnuDirector();

	// service
	MGnuCache* GetCache(){ASSERT(m_pCache);return m_pCache;}
	MGnuShare* GetShare(){ASSERT(m_pShare);return m_pShare;}
	MGnuPreferences* GetPrefs(){ASSERT(m_pPrefs);return m_pPrefs;}
	void AttachCache(MGnuCache*);
	void DetachCache(MGnuCache*);
	void AttachShare(MGnuShare*);
	void DetachShare(MGnuShare*);
	
	const GUID* GetClientID(){return &m_ClientID;}
	WORD GetLocalPort(){return m_nPort;}
	// more management functions
	bool CheckIP(const IP&);
	bool BehindFirewall();
	bool NotLocal(Node);
	
	// search
	MGnuSearch* AddSearch(const CString& search, int type, int size, int sizeMode);
	bool AddSearch(MGnuSearch* pSearch);
	void ForEachSearch(void* pData, tEachSearch callback);
	MGnuSearch* GetSearchByID(DWORD dwID);
	bool GetSearchByID(DWORD dwID, SGnuSearch& gs, std::vector<Result>& rv, std::vector<ResultGroup>& gv);
	bool GetResultsByID(DWORD dwID, std::vector<Result>& rv);
	bool ClearSearchByID(DWORD dwID);
	bool RemoveSearchByID(DWORD dwID);
	MGnuSearch* LookUpSearch(const CString& search, int size);
	//
	void ForEachConnection(void* pData, tEachConnection callback);
	bool CloseConnectionByID(DWORD dwID);
	//
	void ForEachUpload(void* pData, tEachUpload callback);
	void ForEachDownload(void* pData, tEachDownload callback);
	bool RemoveTransferByID(DWORD dwID, bool bDelPart);
	//
	void OnQueryHit(packet_QueryHit* pHit, MGnuNode* pOrigin, bool bOur);
	// Listening control
	bool StartListening();
	void StopListening();
    //
	bool AllowMakingConnections();
	bool AllowIncomingConnections(){return true;}
	// Traffic control
	void Post_QueryHit(QueryComp* pSearchQuery, const BYTE* QueryReply, DWORD QueryReplyLength, BYTE ReplyCount);
	void Broadcast_Ping(packet_Ping*,   int, MGnuNode*);
	void Broadcast_Query(packet_Query*, int, MGnuNode*);
	GUID Broadcast_LocalQuery(BYTE*, WORD, int);
	void SendAllLocalQueries(MGnuNode* pNode);

	void Route_Pong(packet_Pong*, int, key_Value*);
	void Route_QueryHit(packet_QueryHit *, DWORD, key_Value*);
	void Route_Push(packet_Push*, int, key_Value*);
	bool Route_LocalPush(const Result&);

	// Node control
	void AddNode(CString host, UINT port, bool bForceV4 = false);
	void AddNode(CString uin);
	void RemoveNode(MGnuNode*);
	MGnuNode* FindNode(CString, UINT);
	// net stats
	void GetNetStats(int& nHosts, int& nSharingHosts, int& nFiles, int& nSize);
	// Socket Counts
	int  CountConnections();
	int  CountConnPerSubnet(int SubnetBits, IP ipHost);
	int  GetLastConnCount(){ return m_nLastConnCount;}
	int  CountUploading();
	int  CountDownloading();
	int  CountDownloads(IP, MGnuDownload*);

	// Communications
  // TODO: explore this
	void NodeMessage(UINT, WPARAM);
	void TransferMessage(UINT, WPARAM);

	public:
	virtual void OnAccept(int nErrorCode);
	void OnTimer(); // called once a second
	
	void RemoveNode_MostRecv();
	void RemoveNode_LeastRate();
	void RemoveNode_MaxDrop();
	void AddConnect();
	void ManageBandwidth(float CurrentSpeed, int ConnectNum, int UploadNum);
	void ManageConnects(int nCurrent);
	
	bool IsInTheList(MGnuNode* pNode);
protected:
	MGnuDirector();                         // no implementation
	MGnuDirector(const MGnuDirector& rSrc);  // no implementation

protected:
	MController* m_pController;
	MGnuPreferences* m_pPrefs;
	MGnuCache* m_pCache;
	MGnuShare* m_pShare;
	
	// Local Client Data
	GUID    m_ClientID;
	DWORD   m_dwFiles;
	DWORD   m_dwFilesSize;
	int		m_nSecsAboveLimitConn; // Seconds over max conn bandwidth
	int     m_nPort;
	// Used to get hostname from an IP, (one per thread)
	hostent* m_HostEnt;
	int m_nReSearchCounter;
	int m_nReSearchTimer;
	//

	std::vector<MGnuNode*>		m_NodeList;
	std::vector<MGnuSock*>		m_SockList;
	std::vector<MGnuDownload*>	m_DownloadList;
	std::vector<MGnuUpload*>	m_UploadList;
	std::vector<MGnuSearch*> m_SearchList;
	std::list<MGnuSearch*>   m_PendingQueries;
	// access control to the lists above
	MMutex m_listmutex;
	//
	std::queue<QueuedHit> m_hitQueue;
	MMutex m_hitqueuemutex;
	//
	int m_nLastConnCount;
public:
	// Hash tables are thread safe, nothing bad should happen to them
	MGnuHash m_TableQuery;
	MGnuHash m_TablePing;
	MGnuHash m_TablePush;
	MGnuHash m_TableLocal;
	//
	int m_nQGood;
	int m_nQRepeat;
	int m_nQError;
	
	DWORD m_dwConnBytesRecv;
	DWORD m_dwConnBytesSend;
	DWORD m_dwConnRecvRate;
	DWORD m_dwConnSendRate;
	
	double m_dDownloadRate;
	double m_dUploadRate;
	
	//
	int GetUploadsCount(const IP& host, MGnuUpload* pExcept);
	void AddSock(MGnuSock*);
	void AddNode(MGnuNode*);
	void AddUpload(MGnuUpload*);
	bool CheckIfPushung(packet_Push* Push);
	MGnuDownload* LookUpDownload(CString FileName, int Index);
	bool IsOkForDirectConnect(const IP& host);
	//
	void AddDownload(MGnuDownload*);
	void ReplaceDownload(MGnuDownload* what, MGnuDownload* withwhat);
	void AddDownload(Result& result);
	void AddDownload(const ResultVec& results);
};

/////////////////////////////////////////////////////////////////////////////

#endif // __GNUDIRECTOR_H_INCLUDED__
