/***************************************************************************
                          gnucache.h  -  interface for the MGnuCache class.
                             -------------------
    begin                : Sat Sep 1 2001
    copyright            : (C) 2001 by
    email                : maksik@gmx.co.uk
 ***************************************************************************/

// the original version of this file was taken from Gnucleus (http://gnucleus.sourceforge.net)

#if !defined(__GNUCACHE_H_INCLUDED__)
#define __GNUCACHE_H_INCLUDED__

class MGnuDirector;

class MGnuCache  
{
public:
	MGnuCache(MGnuDirector*);
	virtual ~MGnuCache();

	void LoadNodes(CString);
	void SaveNodes(CString);

	bool NotRecent(IP);

	void UpdateCache(Node);
	void SendCache(MGnuNode* pNode, int nHosts);
	bool GetRandomNode(Node& rNode);
	
	void GetNodeList(std::list<Node>& list);

	int			    m_CurrentPos;
protected:
	MMutex m_cachemutex;
	std::list<Node> m_Current; // Node list built as program runs
	std::list<Node> m_Cached;  // Node list loaded from file
	std::list<IP>   m_RecentIPs;	
	
	MGnuCache();                       // no implementation
	MGnuCache(const MGnuCache& rSrc);  // no implementation
private:
	MGnuDirector* m_pDirector;

};

#endif // __GNUCACHE_H_INCLUDED__
