with System;
package ada_main is
   pragma Warnings (Off);

   gnat_argc : Integer;
   gnat_argv : System.Address;
   gnat_envp : System.Address;

   pragma Import (C, gnat_argc);
   pragma Import (C, gnat_argv);
   pragma Import (C, gnat_envp);

   gnat_exit_status : Integer;
   pragma Import (C, gnat_exit_status);

   GNAT_Version : constant String :=
                    "GNAT Version: 4.0.3 (Debian 4.0.3-1)";
   pragma Export (C, GNAT_Version, "__gnat_version");

   Ada_Main_Program_Name : constant String := "_ada_music123" & Ascii.NUL;
   pragma Export (C, Ada_Main_Program_Name, "__gnat_ada_main_program_name");

   procedure adafinal;
   pragma Export (C, adafinal, "adafinal");

   procedure adainit;
   pragma Export (C, adainit, "adainit");

   procedure Break_Start;
   pragma Import (C, Break_Start, "__gnat_break_start");

   function main
     (argc : Integer;
      argv : System.Address;
      envp : System.Address)
      return Integer;
   pragma Export (C, main, "main");

   type Version_32 is mod 2 ** 32;
   u00001 : constant Version_32 := 16#0757acfb#;
   u00002 : constant Version_32 := 16#ddbfb074#;
   u00003 : constant Version_32 := 16#34465398#;
   u00004 : constant Version_32 := 16#7cd43be2#;
   u00005 : constant Version_32 := 16#fd2e500b#;
   u00006 : constant Version_32 := 16#98523f96#;
   u00007 : constant Version_32 := 16#4f66def4#;
   u00008 : constant Version_32 := 16#86250a89#;
   u00009 : constant Version_32 := 16#e6f75b15#;
   u00010 : constant Version_32 := 16#f1813e7d#;
   u00011 : constant Version_32 := 16#8b54c5bc#;
   u00012 : constant Version_32 := 16#92b8f2d3#;
   u00013 : constant Version_32 := 16#a4bd2c31#;
   u00014 : constant Version_32 := 16#fbb17a39#;
   u00015 : constant Version_32 := 16#69c55dba#;
   u00016 : constant Version_32 := 16#543d5469#;
   u00017 : constant Version_32 := 16#83abd5e5#;
   u00018 : constant Version_32 := 16#7cdea8da#;
   u00019 : constant Version_32 := 16#b6955a05#;
   u00020 : constant Version_32 := 16#f8d02a61#;
   u00021 : constant Version_32 := 16#94010ee7#;
   u00022 : constant Version_32 := 16#b9e805a4#;
   u00023 : constant Version_32 := 16#279b6d6d#;
   u00024 : constant Version_32 := 16#4f007b7a#;
   u00025 : constant Version_32 := 16#aeed925e#;
   u00026 : constant Version_32 := 16#50660ef8#;
   u00027 : constant Version_32 := 16#f8f3f145#;
   u00028 : constant Version_32 := 16#90834c04#;
   u00029 : constant Version_32 := 16#3db13619#;
   u00030 : constant Version_32 := 16#1e1b7442#;
   u00031 : constant Version_32 := 16#f48edb4a#;
   u00032 : constant Version_32 := 16#af47252a#;
   u00033 : constant Version_32 := 16#1d4bf469#;
   u00034 : constant Version_32 := 16#ed37450a#;
   u00035 : constant Version_32 := 16#25b5970d#;
   u00036 : constant Version_32 := 16#a052d48b#;
   u00037 : constant Version_32 := 16#6e30287c#;
   u00038 : constant Version_32 := 16#62496d9e#;
   u00039 : constant Version_32 := 16#e073d07d#;
   u00040 : constant Version_32 := 16#e47b2fce#;
   u00041 : constant Version_32 := 16#3b97d790#;
   u00042 : constant Version_32 := 16#71beb871#;
   u00043 : constant Version_32 := 16#c440bd15#;
   u00044 : constant Version_32 := 16#6f4f2daa#;
   u00045 : constant Version_32 := 16#af572fee#;
   u00046 : constant Version_32 := 16#bbde1550#;
   u00047 : constant Version_32 := 16#04e247f8#;
   u00048 : constant Version_32 := 16#817d72ce#;
   u00049 : constant Version_32 := 16#ca27a7d6#;
   u00050 : constant Version_32 := 16#54d40212#;
   u00051 : constant Version_32 := 16#97f07d75#;
   u00052 : constant Version_32 := 16#e2bd33be#;
   u00053 : constant Version_32 := 16#f16515de#;
   u00054 : constant Version_32 := 16#60330f9b#;
   u00055 : constant Version_32 := 16#08edcba9#;
   u00056 : constant Version_32 := 16#37317494#;
   u00057 : constant Version_32 := 16#454a6099#;
   u00058 : constant Version_32 := 16#4fd02447#;
   u00059 : constant Version_32 := 16#acd3261e#;
   u00060 : constant Version_32 := 16#c0778b5d#;
   u00061 : constant Version_32 := 16#1a23c252#;
   u00062 : constant Version_32 := 16#85eaaaa9#;
   u00063 : constant Version_32 := 16#17e7e366#;
   u00064 : constant Version_32 := 16#15c5b84a#;
   u00065 : constant Version_32 := 16#3d453657#;
   u00066 : constant Version_32 := 16#65af5a34#;
   u00067 : constant Version_32 := 16#2383d18b#;
   u00068 : constant Version_32 := 16#cba6250b#;
   u00069 : constant Version_32 := 16#a7377872#;
   u00070 : constant Version_32 := 16#76b81b7e#;
   u00071 : constant Version_32 := 16#c8fe9d86#;
   u00072 : constant Version_32 := 16#f9f5775b#;
   u00073 : constant Version_32 := 16#5674689d#;
   u00074 : constant Version_32 := 16#d9d819c9#;
   u00075 : constant Version_32 := 16#7ab2620b#;
   u00076 : constant Version_32 := 16#4e370440#;
   u00077 : constant Version_32 := 16#0a3f4443#;
   u00078 : constant Version_32 := 16#0c72624c#;
   u00079 : constant Version_32 := 16#cbec2f91#;
   u00080 : constant Version_32 := 16#3c52a65b#;
   u00081 : constant Version_32 := 16#41e05d9d#;
   u00082 : constant Version_32 := 16#ed6e7995#;
   u00083 : constant Version_32 := 16#47671693#;
   u00084 : constant Version_32 := 16#7cf2b4e8#;
   u00085 : constant Version_32 := 16#cc16f521#;
   u00086 : constant Version_32 := 16#50c9b820#;
   u00087 : constant Version_32 := 16#560e4d22#;
   u00088 : constant Version_32 := 16#638b950d#;
   u00089 : constant Version_32 := 16#59abbcbb#;
   u00090 : constant Version_32 := 16#8677c1b0#;
   u00091 : constant Version_32 := 16#67011681#;
   u00092 : constant Version_32 := 16#1af20382#;
   u00093 : constant Version_32 := 16#eb4b66cd#;
   u00094 : constant Version_32 := 16#7a8237ff#;
   u00095 : constant Version_32 := 16#4a9c1253#;
   u00096 : constant Version_32 := 16#84bf3d21#;
   u00097 : constant Version_32 := 16#345a60e7#;
   u00098 : constant Version_32 := 16#f9628c90#;
   u00099 : constant Version_32 := 16#52faabc4#;
   u00100 : constant Version_32 := 16#d1cceae8#;
   u00101 : constant Version_32 := 16#5728f24e#;
   u00102 : constant Version_32 := 16#c55e8c5f#;
   u00103 : constant Version_32 := 16#a342ddaa#;
   u00104 : constant Version_32 := 16#d24187d5#;
   u00105 : constant Version_32 := 16#f07721fe#;
   u00106 : constant Version_32 := 16#b6d80504#;
   u00107 : constant Version_32 := 16#a0376616#;
   u00108 : constant Version_32 := 16#4404d916#;
   u00109 : constant Version_32 := 16#adf24b61#;
   u00110 : constant Version_32 := 16#d7fe710a#;
   u00111 : constant Version_32 := 16#59223bca#;
   u00112 : constant Version_32 := 16#86b1726d#;
   u00113 : constant Version_32 := 16#757d4cfe#;
   u00114 : constant Version_32 := 16#66fa80a1#;
   u00115 : constant Version_32 := 16#790dd969#;
   u00116 : constant Version_32 := 16#5bb4bdb0#;
   u00117 : constant Version_32 := 16#d4994fe5#;
   u00118 : constant Version_32 := 16#deae0a46#;
   u00119 : constant Version_32 := 16#1fc6b200#;
   u00120 : constant Version_32 := 16#70034dec#;
   u00121 : constant Version_32 := 16#e279999f#;
   u00122 : constant Version_32 := 16#6ec50a72#;
   u00123 : constant Version_32 := 16#e74bd513#;
   u00124 : constant Version_32 := 16#d5cc8b86#;
   u00125 : constant Version_32 := 16#4e2c5469#;
   u00126 : constant Version_32 := 16#f591b811#;
   u00127 : constant Version_32 := 16#351efea5#;
   u00128 : constant Version_32 := 16#e8c3905e#;
   u00129 : constant Version_32 := 16#65a52972#;
   u00130 : constant Version_32 := 16#b00414f2#;
   u00131 : constant Version_32 := 16#1de1ef65#;
   u00132 : constant Version_32 := 16#8445b02d#;
   u00133 : constant Version_32 := 16#25ac77e3#;
   u00134 : constant Version_32 := 16#3d85c302#;
   u00135 : constant Version_32 := 16#28ed9beb#;
   u00136 : constant Version_32 := 16#1980b3e0#;
   u00137 : constant Version_32 := 16#8deb8758#;
   u00138 : constant Version_32 := 16#aee3ceea#;
   u00139 : constant Version_32 := 16#228e630f#;
   u00140 : constant Version_32 := 16#7e10dab6#;
   u00141 : constant Version_32 := 16#96ccb8c9#;
   u00142 : constant Version_32 := 16#0f236f37#;

   pragma Export (C, u00001, "music123B");
   pragma Export (C, u00002, "system__standard_libraryB");
   pragma Export (C, u00003, "system__standard_libraryS");
   pragma Export (C, u00004, "adaS");
   pragma Export (C, u00005, "ada__command_lineB");
   pragma Export (C, u00006, "ada__command_lineS");
   pragma Export (C, u00007, "systemS");
   pragma Export (C, u00008, "system__secondary_stackB");
   pragma Export (C, u00009, "system__secondary_stackS");
   pragma Export (C, u00010, "system__parametersB");
   pragma Export (C, u00011, "system__parametersS");
   pragma Export (C, u00012, "system__soft_linksB");
   pragma Export (C, u00013, "system__soft_linksS");
   pragma Export (C, u00014, "system__machine_state_operationsB");
   pragma Export (C, u00015, "system__machine_state_operationsS");
   pragma Export (C, u00016, "system__machine_codeS");
   pragma Export (C, u00017, "system__memoryB");
   pragma Export (C, u00018, "system__memoryS");
   pragma Export (C, u00019, "ada__exceptionsB");
   pragma Export (C, u00020, "ada__exceptionsS");
   pragma Export (C, u00021, "ada__exceptions__last_chance_handlerB");
   pragma Export (C, u00022, "ada__exceptions__last_chance_handlerS");
   pragma Export (C, u00023, "interfacesS");
   pragma Export (C, u00024, "system__exception_tableB");
   pragma Export (C, u00025, "system__exception_tableS");
   pragma Export (C, u00026, "system__htableB");
   pragma Export (C, u00027, "system__htableS");
   pragma Export (C, u00028, "system__storage_elementsB");
   pragma Export (C, u00029, "system__storage_elementsS");
   pragma Export (C, u00030, "system__tracebackB");
   pragma Export (C, u00031, "system__tracebackS");
   pragma Export (C, u00032, "system__unsigned_typesS");
   pragma Export (C, u00033, "system__traceback_entriesB");
   pragma Export (C, u00034, "system__traceback_entriesS");
   pragma Export (C, u00035, "system__crtlS");
   pragma Export (C, u00036, "system__exceptionsS");
   pragma Export (C, u00037, "system__stack_checkingB");
   pragma Export (C, u00038, "system__stack_checkingS");
   pragma Export (C, u00039, "ada__stringsS");
   pragma Export (C, u00040, "ada__strings__unboundedB");
   pragma Export (C, u00041, "ada__strings__unboundedS");
   pragma Export (C, u00042, "ada__strings__fixedB");
   pragma Export (C, u00043, "ada__strings__fixedS");
   pragma Export (C, u00044, "ada__strings__mapsB");
   pragma Export (C, u00045, "ada__strings__mapsS");
   pragma Export (C, u00046, "system__bit_opsB");
   pragma Export (C, u00047, "system__bit_opsS");
   pragma Export (C, u00048, "system__pure_exceptionsS");
   pragma Export (C, u00049, "ada__charactersS");
   pragma Export (C, u00050, "ada__characters__latin_1S");
   pragma Export (C, u00051, "ada__strings__searchB");
   pragma Export (C, u00052, "ada__strings__searchS");
   pragma Export (C, u00053, "system__compare_array_unsigned_8B");
   pragma Export (C, u00054, "system__compare_array_unsigned_8S");
   pragma Export (C, u00055, "system__address_operationsB");
   pragma Export (C, u00056, "system__address_operationsS");
   pragma Export (C, u00057, "ada__finalizationB");
   pragma Export (C, u00058, "ada__finalizationS");
   pragma Export (C, u00059, "system__finalization_rootB");
   pragma Export (C, u00060, "system__finalization_rootS");
   pragma Export (C, u00061, "ada__streamsS");
   pragma Export (C, u00062, "ada__tagsB");
   pragma Export (C, u00063, "ada__tagsS");
   pragma Export (C, u00064, "system__finalization_implementationB");
   pragma Export (C, u00065, "system__finalization_implementationS");
   pragma Export (C, u00066, "system__restrictionsB");
   pragma Export (C, u00067, "system__restrictionsS");
   pragma Export (C, u00068, "system__string_ops_concat_3B");
   pragma Export (C, u00069, "system__string_ops_concat_3S");
   pragma Export (C, u00070, "system__string_opsB");
   pragma Export (C, u00071, "system__string_opsS");
   pragma Export (C, u00072, "system__stream_attributesB");
   pragma Export (C, u00073, "system__stream_attributesS");
   pragma Export (C, u00074, "ada__io_exceptionsS");
   pragma Export (C, u00075, "ada__text_ioB");
   pragma Export (C, u00076, "ada__text_ioS");
   pragma Export (C, u00077, "interfaces__c_streamsB");
   pragma Export (C, u00078, "interfaces__c_streamsS");
   pragma Export (C, u00079, "system__file_ioB");
   pragma Export (C, u00080, "system__file_ioS");
   pragma Export (C, u00081, "system__file_control_blockS");
   pragma Export (C, u00082, "ada__finalization__list_controllerB");
   pragma Export (C, u00083, "ada__finalization__list_controllerS");
   pragma Export (C, u00084, "intlB");
   pragma Export (C, u00085, "intlS");
   pragma Export (C, u00086, "interfaces__cB");
   pragma Export (C, u00087, "interfaces__cS");
   pragma Export (C, u00088, "interfaces__c__stringsB");
   pragma Export (C, u00089, "interfaces__c__stringsS");
   pragma Export (C, u00090, "support_routinesB");
   pragma Export (C, u00091, "support_routinesS");
   pragma Export (C, u00092, "ada__calendarB");
   pragma Export (C, u00093, "ada__calendarS");
   pragma Export (C, u00094, "system__arith_64B");
   pragma Export (C, u00095, "system__arith_64S");
   pragma Export (C, u00096, "system__os_primitivesB");
   pragma Export (C, u00097, "system__os_primitivesS");
   pragma Export (C, u00098, "ada__calendar__delaysB");
   pragma Export (C, u00099, "ada__calendar__delaysS");
   pragma Export (C, u00100, "system__tracesB");
   pragma Export (C, u00101, "system__tracesS");
   pragma Export (C, u00102, "ada__command_line__environmentB");
   pragma Export (C, u00103, "ada__command_line__environmentS");
   pragma Export (C, u00104, "ada__numericsS");
   pragma Export (C, u00105, "ada__numerics__float_randomB");
   pragma Export (C, u00106, "ada__numerics__float_randomS");
   pragma Export (C, u00107, "system__img_intB");
   pragma Export (C, u00108, "system__img_intS");
   pragma Export (C, u00109, "system__string_ops_concat_5B");
   pragma Export (C, u00110, "system__string_ops_concat_5S");
   pragma Export (C, u00111, "system__string_ops_concat_4B");
   pragma Export (C, u00112, "system__string_ops_concat_4S");
   pragma Export (C, u00113, "system__val_intB");
   pragma Export (C, u00114, "system__val_intS");
   pragma Export (C, u00115, "system__val_unsB");
   pragma Export (C, u00116, "system__val_unsS");
   pragma Export (C, u00117, "system__val_utilB");
   pragma Export (C, u00118, "system__val_utilS");
   pragma Export (C, u00119, "system__case_utilB");
   pragma Export (C, u00120, "system__case_utilS");
   pragma Export (C, u00121, "gnatS");
   pragma Export (C, u00122, "gnat__directory_operationsB");
   pragma Export (C, u00123, "gnat__directory_operationsS");
   pragma Export (C, u00124, "ada__characters__handlingB");
   pragma Export (C, u00125, "ada__characters__handlingS");
   pragma Export (C, u00126, "ada__strings__maps__constantsS");
   pragma Export (C, u00127, "gnat__os_libB");
   pragma Export (C, u00128, "gnat__os_libS");
   pragma Export (C, u00129, "gnat__stringsB");
   pragma Export (C, u00130, "gnat__stringsS");
   pragma Export (C, u00131, "gnat__io_auxB");
   pragma Export (C, u00132, "gnat__io_auxS");
   pragma Export (C, u00133, "system__fat_fltS");
   pragma Export (C, u00134, "ustring_listB");
   pragma Export (C, u00135, "ustring_listS");
   pragma Export (C, u00136, "vectorB");
   pragma Export (C, u00137, "vectorS");
   pragma Export (C, u00138, "system__val_realB");
   pragma Export (C, u00139, "system__val_realS");
   pragma Export (C, u00140, "system__exn_llfB");
   pragma Export (C, u00141, "system__exn_llfS");
   pragma Export (C, u00142, "system__powten_tableS");

   --  BEGIN ELABORATION ORDER
   --  ada%s
   --  ada.characters%s
   --  ada.characters.handling%s
   --  ada.characters.latin_1%s
   --  ada.command_line%s
   --  ada.command_line.environment%s
   --  gnat%s
   --  gnat.strings%s
   --  gnat.strings%b
   --  interfaces%s
   --  system%s
   --  system.address_operations%s
   --  system.address_operations%b
   --  system.arith_64%s
   --  system.bit_ops%s
   --  system.case_util%s
   --  system.case_util%b
   --  system.compare_array_unsigned_8%s
   --  system.exn_llf%s
   --  system.exn_llf%b
   --  system.htable%s
   --  system.htable%b
   --  system.img_int%s
   --  system.machine_code%s
   --  system.os_primitives%s
   --  system.os_primitives%b
   --  system.parameters%s
   --  system.parameters%b
   --  system.crtl%s
   --  interfaces.c_streams%s
   --  interfaces.c_streams%b
   --  system.powten_table%s
   --  system.pure_exceptions%s
   --  system.arith_64%b
   --  system.restrictions%s
   --  system.restrictions%b
   --  system.standard_library%s
   --  system.storage_elements%s
   --  system.storage_elements%b
   --  system.compare_array_unsigned_8%b
   --  system.secondary_stack%s
   --  system.img_int%b
   --  ada.command_line.environment%b
   --  ada.command_line%b
   --  system.stack_checking%s
   --  system.stack_checking%b
   --  system.string_ops%s
   --  system.string_ops%b
   --  system.string_ops_concat_3%s
   --  system.string_ops_concat_3%b
   --  system.string_ops_concat_4%s
   --  system.string_ops_concat_4%b
   --  system.string_ops_concat_5%s
   --  system.string_ops_concat_5%b
   --  system.traceback%s
   --  system.traceback%b
   --  system.traceback_entries%s
   --  system.traceback_entries%b
   --  ada.exceptions%s
   --  ada.exceptions.last_chance_handler%s
   --  ada.exceptions.last_chance_handler%b
   --  system.exceptions%s
   --  system.machine_state_operations%s
   --  system.soft_links%s
   --  system.soft_links%b
   --  system.secondary_stack%b
   --  system.exception_table%s
   --  system.exception_table%b
   --  ada.calendar%s
   --  ada.calendar%b
   --  ada.calendar.delays%s
   --  ada.io_exceptions%s
   --  ada.numerics%s
   --  ada.numerics.float_random%s
   --  ada.strings%s
   --  ada.tags%s
   --  ada.tags%b
   --  ada.streams%s
   --  gnat.os_lib%s
   --  gnat.os_lib%b
   --  interfaces.c%s
   --  interfaces.c%b
   --  interfaces.c.strings%s
   --  interfaces.c.strings%b
   --  system.finalization_root%s
   --  system.finalization_root%b
   --  system.memory%s
   --  system.memory%b
   --  system.machine_state_operations%b
   --  system.standard_library%b
   --  system.traces%s
   --  system.traces%b
   --  ada.calendar.delays%b
   --  system.unsigned_types%s
   --  ada.exceptions%b
   --  system.bit_ops%b
   --  ada.strings.maps%s
   --  ada.strings.maps%b
   --  ada.strings.fixed%s
   --  ada.strings.maps.constants%s
   --  ada.characters.handling%b
   --  ada.strings.search%s
   --  ada.strings.search%b
   --  ada.strings.fixed%b
   --  system.fat_flt%s
   --  system.stream_attributes%s
   --  system.stream_attributes%b
   --  system.finalization_implementation%s
   --  system.finalization_implementation%b
   --  ada.finalization%s
   --  ada.finalization%b
   --  ada.finalization.list_controller%s
   --  ada.finalization.list_controller%b
   --  ada.strings.unbounded%s
   --  ada.strings.unbounded%b
   --  gnat.directory_operations%s
   --  gnat.directory_operations%b
   --  system.file_control_block%s
   --  system.file_io%s
   --  system.file_io%b
   --  ada.text_io%s
   --  ada.text_io%b
   --  gnat.io_aux%s
   --  gnat.io_aux%b
   --  system.val_int%s
   --  ada.numerics.float_random%b
   --  system.val_real%s
   --  system.val_uns%s
   --  system.val_util%s
   --  system.val_util%b
   --  system.val_uns%b
   --  system.val_real%b
   --  system.val_int%b
   --  intl%s
   --  intl%b
   --  vector%s
   --  vector%b
   --  ustring_list%s
   --  ustring_list%b
   --  support_routines%s
   --  support_routines%b
   --  music123%b
   --  END ELABORATION ORDER

end ada_main;
