//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: mitplugin.h,v 1.3 2002/01/03 11:30:04 muse Exp $
//
//  (C) Copyright 2001 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __MITPLUGIN_H__
#define __MITPLUGIN_H__

#include <list>

class MidiEvent;
class Xml;

//---------------------------------------------------------
//   MITPlugin
//    midi input transform plugin
//---------------------------------------------------------

class MITPlugin {
   public:
      virtual void process(MidiEvent* event) = 0;
      virtual void readStatus(Xml&) {}
      virtual void writeStatus(int, Xml&) const {}
      };

typedef std::list<MITPlugin*> MITPluginList;
typedef MITPluginList::iterator iMITPlugin;

extern MITPluginList mitPlugins;
extern void processMidiInputTransformPlugins(MidiEvent*);
extern void writeStatusMidiInputTransformPlugins(int, Xml&);
extern void readStatusMidiInputTransformPlugin(Xml&);

#endif

