//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: midithread.h,v 1.2 2001/11/20 15:19:31 muse Exp $
//
//  (C) Copyright 2001 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __SEQTHREAD_H__
#define __SEQTHREAD_H__

#include <qobject.h>
#include "thread.h"

class Part;
class Event;
class MidiEvent;
class Track;
class MidiPort;
class MidiDevice;
class EventList;
class MTC;
struct MidiThreadPrivate;
class SynthI;
class MidiInstrument;

//---------------------------------------------------------
//   MidiMsgId
//    this are the messages send from the GUI thread to
//    the midi thread
//---------------------------------------------------------

enum MidiMsgId {
      SEQM_ADD_TRACK, SEQM_REMOVE_TRACKS, SEQM_CHANGE_TRACK, SEQM_MOVE_TRACK,
      SEQM_ADD_PART, SEQM_REMOVE_PART, SEQM_CHANGE_PART,
      SEQM_ADD_EVENT, SEQM_REMOVE_EVENT, SEQM_CHANGE_EVENT,
      SEQM_ADD_TEMPO, SEQM_SET_TEMPO, SEQM_REMOVE_TEMPO, SEQM_ADD_SIG,
      SEQM_UNDO, SEQM_REDO,
      SEQM_RESET_DEVICES, SEQM_INIT_DEVICES, SEQM_MIDI_LOCAL_OFF,
      SEQM_MIDI_CTRL, SEQM_MIDI_MASTER_VOLUME,
      SEQM_SET_MIDI_DEVICE,
      SEQM_PLAY_MIDI_EVENT,
      SEQM_SET_MIXDOWN,
      SEQM_SET_RTC_TICKS,
      SEQM_SEEK, SEQM_PLAY,
      SEQM_SCAN_ALSA_MIDI_PORTS,
      SEQM_REMOVE_SYNTHI, SEQM_ADD_SYNTHI,
      MIDI_ADD_SYNTHI, MIDI_SHOW_INSTR_GUI,
      };

//---------------------------------------------------------
//   MidiMsg
//---------------------------------------------------------

struct MidiMsg : public ThreadMsg {
      void* p1;
      void* p2;
      void* p3;

      char port;
      char channel;
      char ctrl;

      int a;
      int b;
      int c;
      };

//---------------------------------------------------------
//   MidiThread
//---------------------------------------------------------

class MidiThread : public QObject, public Thread {
      Q_OBJECT;

      QTimer* heartBeatTimer;       // controls gui refreshes
      MidiThreadPrivate* data;

      virtual void processMsg(const ThreadMsg*);
      virtual void defaultTick();

      void updatePollFd();
      bool setRtcTicks();
      int recTimeStamp() const;
      void recordStop();
      void sendLocalOff();
      bool filterEvent(const MidiEvent* event, int type, bool thru);
      void mtcSyncMsg(const MTC& mtc, bool seekFlag);
      void statePlay();
      static void midiTick(void* p, void*);
      void initDevices();

   public slots:
      void seqSignal(int fd);
      void resetDevices();
      void msgInitDevices();
      void localOff();
      void heartBeat();

   signals:
      void midiNote(int, int);

   public:
      MidiThread(bool rt=true, int prio=50, bool ml = true);
      ~MidiThread();
      virtual void start();
      bool sendMessage(const MidiMsg* m, bool doUndo);

      bool isPlaying() const;
      void setHeartBeat();

      //-----------------------------------------
      //   message interface
      //-----------------------------------------

      void msgSeek(int val);
      void msgPlay(bool val);

      void msgAddTrack(Track* track, bool u = true);
      void msgRemoveTracks(bool u = true);
      void msgChangeTrack(Track* oldTrack, Track* newTrack, bool u = true);
      void msgMoveTrack(int idx1, int dx2, bool u = true);
      void msgAddPart(Part*, bool u = true);
      void msgRemovePart(Part*, bool u = true);
      void msgChangePart(Part* oldPart, Part* newPart, bool u = true);
      void msgAddEvent(Event*, Part*, bool u = true);
      void msgDeleteEvent(Event*, Part*, bool u = true);
      void msgChangeEvent(Event*, Event*, Part*, bool u = true);
      void msgScanAlsaMidiPorts();
      void msgAddTempo(int tick, int tempo, bool doUndoFlag = true);
      void msgSetTempo(int tick, int tempo, bool doUndoFlag = true);
      void msgDeleteTempo(int tick, int tempo, bool doUndoFlag = true);
      void msgAddSig(int tick, int z, int n, bool doUndoFlag = true);
      void msgAddSynthI(SynthI* synth);
      void msgShowInstrumentGui(MidiInstrument*, bool);

      void undo();
      void redo();
      void ctrlChanged(int port, int channel, int ctrl, int val);
      void masterVolChanged(int val);

      void setMidiDevice(MidiPort*, MidiDevice*);
      void playMidiEvent(MidiEvent* event);
      void rescanAlsaPorts();
      int curTickPos() const;

      void eventReceived(MidiEvent* event);

      void mmcInput(const unsigned char* p, int n);
      void mtcInputQuarter(int, unsigned char c);
      void mtcInputFull(const unsigned char* p, int n);
      void eventReceived(int, unsigned char chan, unsigned char c1, unsigned c2);
      void nonRealtimeSystemSysex(const unsigned char*, int);
      void realtimeSystemInput(int, int);
      void setSongPosition(int, int);
      void midiPortsChanged();
      };

#endif

