//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: globals.h,v 1.6 2002/02/27 08:48:09 muse Exp $
//
//  (C) Copyright 1999/2000 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef GLOBALS_H
#define GLOBALS_H

#include <qstring.h>
#include <qfont.h>
#include <qnamespace.h>
#include <qaction.h>
#include "value.h"
#include "mtc.h"

class Song;
class Sequencer;
class MidiThread;
class AudioThread;
class AudioPrefetch;

extern bool alsaFound;
extern Song* song;
extern Sequencer* seq;
extern MidiThread* midiThread;
extern AudioThread* audioThread;
extern AudioPrefetch* audioPrefetch;

extern int division;
extern volatile int sampleRate;
extern volatile int segmentSize;
extern int rtcTicks;
extern int minMeter;
extern int minSlider;
extern int guiRefresh;
extern bool noAudio;

extern bool hIsB;

extern int configFontSize;

extern const char sharpTab[14][7];
extern const char flatTab[14][7];

class SndFileList;
extern SndFileList* sndFiles;

class ClipList;
extern ClipList* waveClips;

extern QString museGlobalLib;
extern QString museGlobalShare;
extern QString museUser;
extern QString museProject;

extern bool debugMode;
extern bool midiInputTrace;
extern bool midiOutputTrace;
extern bool debugMsg;
extern bool debugSync;

extern bool realTimeScheduling;
extern int realTimePriority;
extern bool lockMemory;
extern const char* midi_file_pattern[];
extern const char* med_file_pattern[];
extern const char* image_file_pattern[];
extern const char* ctrl_file_pattern[];

extern QString scoreBg;    // Background Pixmap Pathname for score canvas

extern double paperWidth;
extern double paperHeight;
extern double topMargin;
extern double bottomMargin;
extern double leftMargin;
extern double rightMargin;
extern double printScale;
extern int barsPage;
extern double beamWidth;
extern double beamSpacing;
extern double beamSlopeTrigger;

extern QFont font0;       // 12pt
extern QFont font1;       // 8pt
extern QFont font2;       // 10 pt
extern QFont font3;       // 10 pt bold
extern QFont font4;       // 8 pt bold
extern QFont font5;       // 12pt typewriter

extern Qt::ButtonState globalKeyState;

class QApplication;
extern QApplication* qApp;

extern bool extendedMidi;
extern int midiDivision;      // division for midi export

extern int midiInputPorts;          // receive from all devices
extern int midiInputChannel;        // receive all channel
extern int midiRecordType;          // receive all events
#define MIDI_FILTER_NOTEON    1
#define MIDI_FILTER_POLYP     2
#define MIDI_FILTER_CTRL      4
#define MIDI_FILTER_PROGRAM   8
#define MIDI_FILTER_AT        16
#define MIDI_FILTER_PITCH     32
#define MIDI_FILTER_SYSEX     64

extern int midiThruType;            // transmit all events
extern int midiFilterCtrl1;
extern int midiFilterCtrl2;
extern int midiFilterCtrl3;
extern int midiFilterCtrl4;

#define CMD_RANGE_ALL   0
#define CMD_RANGE_SELECTED    1
#define CMD_RANGE_LOOP  2

extern QActionGroup* undoRedo;
extern QAction* undoAction;
extern QAction* redoAction;

class AudioMixerApp;
class MusE;
extern AudioMixerApp* audioMixer;
extern MusE* muse;

extern int extSyncPort;
extern int deviceId;
extern int mtcType;
extern MTC mtcOffset;
extern BValue extSyncFlag;
extern bool genMTCSync;
extern bool genMCSync;
extern bool genMMC;
extern bool acceptMTC;
extern bool acceptMC;
extern bool acceptMMC;

extern int preMeasures;
extern unsigned char measureClickNote;
extern unsigned char measureClickVelo;
extern unsigned char beatClickNote;
extern unsigned char beatClickVelo;
extern unsigned char clickChan;
extern unsigned char clickPort;
extern bool precountEnableFlag;
extern bool precountFromMastertrackFlag;
extern int precountSigZ;
extern int precountSigN;
extern bool precountPrerecord;
extern bool precountPreroll;
extern bool midiClickFlag;
extern bool audioClickFlag;

extern bool rcEnable;
extern unsigned char rcStopNote;
extern unsigned char rcRecordNote;
extern unsigned char rcGotoLeftMarkNote;
extern unsigned char rcPlayNote;

extern uid_t euid, ruid;
extern void doSetuid();
extern void undoSetuid();
#endif
