//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: cfprint.cpp,v 1.1 2002/01/30 14:10:07 muse Exp $
//
//  (C) Copyright 1999/2000 Werner Schweer (ws@seh.de)
//=========================================================

#include "app.h"
#include <qlayout.h>
#include <qlabel.h>
#include <qcheckbox.h>
#include <qbuttongroup.h>
#include <qpushbutton.h>
#include <qlineedit.h>

#include "cfprint.h"
#include "conf.h"
#include "utils.h"

//---------------------------------------------------------
//   configPrinter
//---------------------------------------------------------

void MusE::configPrinter()
      {
      if (printerConfig) {
            printerConfig->show();
            return;
            }
      printerConfig = new PrinterConfig(0, this);
      printerConfig->show();
      }

//---------------------------------------------------------
//   PrinterConfig
//---------------------------------------------------------

PrinterConfig::PrinterConfig(QWidget* parent, MusE* seq)
   : QWidget(parent)
      {
      setCaption(tr("MusE: Config Printer"));
      app = seq;
//      setGeometry(400, 400, 380, 150);

      QVBoxLayout* box  = new QVBoxLayout(this);
      QWidget* w1       = new QWidget(this);
      QGridLayout* f1   = new QGridLayout(w1);

      QCheckBox* f1b1   = new QCheckBox(tr("Print to file"), w1);
      QCheckBox* f1b2   = new QCheckBox(tr("Print Command"), w1);
      QButtonGroup* bg1 = new QButtonGroup(w1);

      QLabel* la1 = new QLabel(tr("Preview Command"), w1);
      edit3 = new QLineEdit(w1);
      edit3->setText(previewCommand);

      bg1->hide();
      bg1->setExclusive(true);
      bg1->insert(f1b1, 1);
      bg1->insert(f1b2, 0);
      connect(bg1, SIGNAL(clicked(int)), SLOT(selPrClass(int)));
      edit1 = new QLineEdit(w1);
      edit2 = new QLineEdit(w1);

      edit1->setText(printerFile);
      edit2->setText(printerCommand);
      toFile = printerType;

      f1b1->setChecked(toFile);
      f1b2->setChecked(!toFile);
      selPrClass(toFile);

      f1->addWidget(f1b1, 0, 0);
      f1->addWidget(f1b2, 1, 0);
      f1->addWidget(edit1, 0, 1);
      f1->addWidget(edit2, 1, 1);
      f1->addWidget(la1, 2, 0);
      f1->addWidget(edit3, 2, 1);
      f1->setColStretch(1, 10);

      box->addWidget(w1, 10);
      box->addWidget(hLine(this), 0);

      //
      //   Button Box
      //
      QBoxLayout* buttons = new QHBoxLayout;
      QButtonGroup* bg = new QButtonGroup(this);
      bg->hide();
      QPushButton* b1   = new QPushButton("OK", this);
      b1->setDefault(true);
      QPushButton* b2   = new QPushButton("Cancel", this);
      b1->setFixedWidth(80);
      b2->setFixedWidth(80);

      buttons->addWidget(b1);
      buttons->addSpacing(12);
      buttons->addWidget(b2);
      buttons->addStretch(1);

      bg->insert(b1, 0);
      bg->insert(b2, 1);

      box->addLayout(buttons);
      connect(bg, SIGNAL(clicked(int)), SLOT(selPrinterAction(int)));
      }

//---------------------------------------------------------
//   selPrClass
//
//    0 - print to file
//    1 - print to command
//---------------------------------------------------------

void PrinterConfig::selPrClass(int i)
      {
      toFile = i;
      edit1->setEnabled(toFile);
      edit2->setEnabled(!toFile);
      }

//---------------------------------------------------------
//   selPrinterAction
//---------------------------------------------------------

void PrinterConfig::selPrinterAction(int i)
      {
      switch (i) {
            case 0:           // OK
                  printerFile = edit1->text();
                  printerCommand = edit2->text();
                  previewCommand = edit3->text();
                  printerType = toFile;
                  break;
            case 1:           // Abort
                  break;
            }
      close(false);
      }

