//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: audioprefetch.cpp,v 1.2 2002/02/27 11:52:58 muse Exp $
//
//  (C) Copyright 2001 Werner Schweer (ws@seh.de)
//=========================================================

#include <poll.h>
#include <stdio.h>
#include <unistd.h>

#include "audioprefetch.h"
#include "globals.h"
#include "track.h"
#include "song.h"

//---------------------------------------------------------
//   AudioPrefetch
//---------------------------------------------------------

AudioPrefetch::AudioPrefetch(bool rt=true, int prio=50, bool ml = true)
   : Thread(rt, prio, ml)
      {
      currentFrameSize = 0;
      }

//---------------------------------------------------------
//   readMsg
//---------------------------------------------------------

static void readMsgP(void* p, void*)
      {
      AudioPrefetch* at = (AudioPrefetch*)p;
      at->readMsg1(sizeof(PrefetchMsg));
      }

//---------------------------------------------------------
//   start
//---------------------------------------------------------

void AudioPrefetch::start()
      {
      clearPollFd();
      addPollFd(toThreadFdr, POLLIN, ::readMsgP, this, 0);
      Thread::start();
      }

//---------------------------------------------------------
//   ~AudioPrefetch
//---------------------------------------------------------

AudioPrefetch::~AudioPrefetch()
      {
      }

//---------------------------------------------------------
//   processMsg
//---------------------------------------------------------

void AudioPrefetch::processMsg1(const void* m)
      {
      const PrefetchMsg* msg = (PrefetchMsg*)m;
      switch(msg->id) {
            case PREFETCH_TICK:
                  prefetch(msg->pos, msg->bufferNo);
                  break;
            }
      }

//---------------------------------------------------------
//   msgTick
//---------------------------------------------------------

void AudioPrefetch::msgTick(int samplePos, int bufferNo)
      {
      if (noAudio)
            return;
      PrefetchMsg msg;
      msg.id = PREFETCH_TICK;
      msg.pos = samplePos;
      msg.bufferNo = bufferNo;
      while (sendMsg1(&msg, sizeof(msg)))
            sleep(1);
      }

//---------------------------------------------------------
//   prefetch
//---------------------------------------------------------

void AudioPrefetch::prefetch(int pos, int bufferNo)
      {
      bool realloc = currentFrameSize != segmentSize;
      TrackList* tl = song->tracks();
      for (iTrack it = tl->begin(); it != tl->end(); ++it) {
            if ((*it)->type() != Track::WAVE)
                  continue;
            WaveTrack* track = (WaveTrack*)(*it);
            track->fetchData(bufferNo, pos, realloc);
            }
      currentFrameSize = segmentSize;
      }

