//deps.h:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2010
 *
 *  This file is part of RoarD,
 *  a sound server daemon for using the RoarAudio protocol.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  or (at your option) any later version as published by
 *  the Free Software Foundation.
 *
 *  RoarAudio is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 */

#ifndef _MUROARD_DEPS_H_
#define _MUROARD_DEPS_H_

/*** define things we disabple below if not supported ***/
#define MUROAR_HAVE_FORK
#define MUROAR_HAVE_FCHMOD
#define MUROAR_HAVE_UMASK

/*** calc general things ***/
#ifndef MUROAR_FEATURE_ARGV
// disable help:
#ifdef MUROARD_FEATURE_HELP_TEXT
#undef MUROARD_FEATURE_HELP_TEXT
#endif
#endif


/*** calc network things ***/
#ifndef MUROAR_FEATURE_SOCKET_LISTEN
// disable all kinds of listen sockets:

// IP sockets:
#ifdef MUROAR_FEATURE_SOCKET_INET
#undef MUROAR_FEATURE_SOCKET_INET
#endif

// UNIX sockets:
#ifdef MUROAR_FEATURE_SOCKET_UNIX
#undef MUROAR_FEATURE_SOCKET_UNIX
#endif
#endif

// disable things Win32 does not support:
#if defined(__WIN32)

// No UNIX sockets support on win32
#ifdef MUROAR_FEATURE_SOCKET_UNIX
#undef MUROAR_FEATURE_SOCKET_UNIX
#endif

// No Signals on win32
#ifdef MUROAR_FEATURE_SIGNALS
#undef MUROAR_FEATURE_SIGNALS
#endif

// No fork() on win32:
#ifdef MUROAR_HAVE_FORK
#undef MUROAR_HAVE_FORK
#endif

// No fchmod() on win32:
#ifdef MUROAR_HAVE_FCHMOD
#undef MUROAR_HAVE_FCHMOD
#endif

// No umask() on win32:
#ifdef MUROAR_HAVE_UMASK
#undef MUROAR_HAVE_UMASK
#endif
#endif


#ifndef MUROAR_FEATURE_SOCKET_UNIX
#ifdef MUROAR_FEATURE_CMD_PASSFH
#undef MUROAR_FEATURE_CMD_PASSFH
#endif
#endif

/*** calc support of functions ***/
#if !defined(MUROAR_HAVE_FORK)
#ifdef MUROAR_FEATURE_DAEMONIZE
#undef MUROAR_FEATURE_DAEMONIZE
#endif
#endif

#ifndef MUROAR_HAVE_FCHMOD
#ifdef MUROAR_DEFAULT_LISTEN_CHMOD
#undef MUROAR_DEFAULT_LISTEN_CHMOD
#endif
#endif

/*** calc list of needed dsp functions ***/
#ifdef MUROAR_FEATURE_UPMIX_INPUT
#define MUROAR_FEATURE_UPMIX
#endif
#ifdef MUROAR_FEATURE_UPSCALE_INPUT
#define MUROAR_FEATURE_UPSCALE
#endif
#ifdef MUROAR_FEATURE_DOWNMIX_OUTPUT
#define MUROAR_FEATURE_DOWNMIX
#endif
#ifdef MUROAR_FEATURE_DOWNSCALE_OUTPUT
#define MUROAR_FEATURE_DOWNSCALE
#endif

/*** calc minimum requirements, throw error if we hit a error ***/
#if !defined(MUROAR_FEATURE_ARGV) && !defined(MUROAR_FEATURE_SOCKET_LISTEN)
#if !(defined(MUROAR_FEATURE_SOCKET_INET) || defined(MUROAR_FEATURE_SOCKET_UNIX))
#error You did not configure any way to comunicate with the clients
#endif
#endif

#endif

//ll
