#include	<sys/types.h>
#include	<sys/stat.h>
#include	<fcntl.h>
#include	<stdlib.h>
#include	<unistd.h>
#include	<string.h>

#include	"murasaki.h"	/* for LOG_LEVEL */
#include	"env.h"

#define	NET_DEV		"/proc/net/dev"
#define	BUF_TMP_SIZE	512

/*
 * wait until a driver has been initialized
 */
int
wait_init(char *name)
{
	int fd;
	int tmp_size = BUF_TMP_SIZE,size,i;
	char *buf,*ptr;
	int len;
	int exit_status = INVALID;

	if ((fd = open(NET_DEV,O_RDONLY)) == -1) {
		DPRINTF(LOG_LEVEL,"open error");
		return exit_status;	/* error */
	}

	buf = malloc(tmp_size);
	if (buf == NULL) {
		DPRINTF(LOG_LEVEL,"allocation error");
		goto return_close;	/* error */
	}
	for(size = 0;(i = read(fd,buf,tmp_size)) != 0;size += i)
		;
	if (size > tmp_size) {
		buf = realloc(buf,size);
		if (buf == NULL) {
			DPRINTF(LOG_LEVEL,"allocation 2 error");
			goto return_free;	/* error */
		}
		lseek(fd,0,SEEK_SET);
		read(fd,buf,size);
	}
	len = strlen(name);
	for(ptr = buf;ptr < buf + size-1;ptr++) {
		DPRINTF(LOG_LEVEL,"*ptr \'%c\'(0x%x)",*ptr,*ptr);
		if (*ptr == ' ')
			continue;
		DPRINTF(LOG_LEVEL,"string:\"%c%c%c%c%c%c\" name:%c%c%c%c",
			*ptr,ptr[1],ptr[2],ptr[3],ptr[4],ptr[5],
			name[0],name[1],name[2],name[3]);
		if (*ptr == name[0] &&
				strncmp(&name[1],&ptr[1],len-1) == 0 &&
				ptr[len] == ':') {
			ptr += len + 1;
			while(*ptr == ' ')
				ptr++;

			DPRINTF(LOG_LEVEL,"yet:\"%c\"",*ptr);
			if ('0' <= *ptr && *ptr <= '9')
				exit_status = GOOD;
			else
				exit_status = NOT_YET;
			break;
		} else {
			while(ptr < buf + size - 1 && *ptr != '\n')
				ptr++;
		}
	}
return_free:
	free(buf);
return_close:
	close(fd);

	DPRINTF(LOG_LEVEL,"wait return %d",exit_status);

	return exit_status;
}
