/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: execute.c,v 3.6 2001/12/16 09:43:22 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdio.h>
#include	<unistd.h>
#include	<errno.h>

#include	"murasaki.h"
#include	"env.h"

#define		UP_CMD		MU_NET_UP
#define		DOWN_CMD	MU_NET_DOWN

int
execute(struct mu_op *opp,int action)
{
	char *arg[3];
	MU_net_config_t *config = opp->config;

	if (action == ACTION_ADD)
		arg[0] = UP_CMD;
	else
#ifdef NEED_NOT_NET_DOWN
		return;
#else
		arg[0] = DOWN_CMD;
#endif
	arg[1] = config->name;
	arg[2] = NULL;

	syslog(LOG_LEVEL,"execute %s %s",arg[0],arg[1]);

	execvp(arg[0],arg);
	syslog(LOG_LEVEL,"exec error \"%s\" err=%d",arg[0],errno);

	return INVALID;
}
